/*
 * Decompiled with CFR 0.152.
 */
package printer.xmi;

import builder.xmi.XMINode;
import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMIPrinter {
    FSTNode root;
    String filename;
    Document xmi = null;
    Element documentRoot;

    public XMIPrinter(FSTNode root, String filename) {
        this.root = root;
        this.filename = filename;
    }

    public void transformDocument() {
        this.documentRoot = this.createRoot();
        this.process();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.xmi);
            FileOutputStream os = new FileOutputStream(this.filename);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private void process() {
        FSTNonTerminal nonterminal = (FSTNonTerminal)this.root;
        for (FSTNode node : nonterminal.getChildren()) {
            XMINode xminode = (XMINode)node;
            this.documentRoot.appendChild(xminode.toXMI(this.xmi));
        }
    }

    private Element createRoot() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.xmi = db.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        Element root = this.xmi.createElement("XMI");
        root.setAttribute("xmi.version", "1.2");
        root.setAttribute("xmlns:UML", "org.omg.xmi.namespace.UML");
        Element header = this.xmi.createElement("XMI.header");
        Element metamodel = this.xmi.createElement("XMI.metamodel");
        metamodel.setAttribute("xmi.name", "UML");
        metamodel.setAttribute("xmi.version", "1.4");
        header.appendChild(metamodel);
        Element content = this.xmi.createElement("XMI.content");
        Element model = this.xmi.createElement("UML:Model");
        model.setAttribute("xmi.id", "");
        Element namespace = this.xmi.createElement("UML:Namespace.ownedElement");
        model.appendChild(namespace);
        content.appendChild(model);
        root.appendChild(content);
        root.appendChild(header);
        this.xmi.appendChild(root);
        return namespace;
    }
}

