/*
 * Decompiled with CFR 0.152.
 */
package printer;

import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import java.io.File;
import java.util.LinkedList;
import printer.PrintVisitorException;
import printer.PrintVisitorInterface;

public class FeaturePrintVisitor {
    private String workingDir = ".";
    private String expressionName = "default.expression";
    private LinkedList<PrintVisitorInterface> visitors = new LinkedList();

    public FeaturePrintVisitor() {
    }

    public FeaturePrintVisitor(String workingDir, String expressionName) {
        this.setWorkingDir(workingDir);
        this.setExpressionName(expressionName);
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setExpressionName(String expressionName) {
        this.expressionName = expressionName;
    }

    public String getExpressionName() {
        return this.expressionName;
    }

    public void registerPrintVisitor(PrintVisitorInterface visitor) {
        this.visitors.add(visitor);
    }

    public void unregisterPrintVisitor(PrintVisitorInterface visitor) {
        this.visitors.remove(visitor);
    }

    public LinkedList<PrintVisitorInterface> getPrintVisitors() {
        return this.visitors;
    }

    public void visit(FSTNonTerminal root) throws PrintVisitorException {
        this.visit(root, null, null, null);
    }

    private void visit(FSTNonTerminal nonterminal, File featurePath, File folderPath, File oldFolderPath) throws PrintVisitorException {
        if (nonterminal != null) {
            if (nonterminal.getType().equals("Feature")) {
                StringBuffer sb = new StringBuffer(this.getExpressionName());
                sb.setLength(sb.lastIndexOf("."));
                sb.delete(0, sb.lastIndexOf(File.separator) + 1);
                featurePath = new File(String.valueOf(this.getWorkingDir()) + File.separator + sb.toString());
                featurePath.mkdir();
                folderPath = featurePath;
                for (FSTNode child : nonterminal.getChildren()) {
                    this.visit((FSTNonTerminal)child, featurePath, folderPath, oldFolderPath);
                }
            } else if (nonterminal.getType().equals("Folder")) {
                oldFolderPath = folderPath;
                folderPath = new File(folderPath, nonterminal.getName());
                folderPath.mkdir();
                for (FSTNode child : nonterminal.getChildren()) {
                    this.visit((FSTNonTerminal)child, featurePath, folderPath, oldFolderPath);
                }
                folderPath = oldFolderPath;
            } else {
                boolean processed = false;
                for (PrintVisitorInterface visitor : this.getPrintVisitors()) {
                    if (!visitor.acceptNode(nonterminal)) continue;
                    visitor.processNode(nonterminal, folderPath);
                    processed = true;
                }
                if (!processed) {
                    System.err.println("Nonterminal type not supported: " + nonterminal.getType());
                }
            }
        }
    }
}

