/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.util.Vector;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.LexGen;
import org.javacc.parser.Nfa;
import org.javacc.parser.NfaState;
import org.javacc.parser.RCharacterList;
import org.javacc.parser.RJustName;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.RegularExpression;

public class RChoice
extends RegularExpression {
    public Vector choices = new Vector();

    @Override
    public Nfa GenerateNfa(boolean ignoreCase) {
        this.CompressCharLists();
        if (this.choices.size() == 1) {
            return ((RegularExpression)this.choices.elementAt(0)).GenerateNfa(ignoreCase);
        }
        Nfa retVal = new Nfa();
        NfaState startState = retVal.start;
        NfaState finalState = retVal.end;
        int i = 0;
        while (i < this.choices.size()) {
            RegularExpression curRE = (RegularExpression)this.choices.elementAt(i);
            Nfa temp = curRE.GenerateNfa(ignoreCase);
            startState.AddMove(temp.start);
            temp.end.AddMove(finalState);
            ++i;
        }
        return retVal;
    }

    void CompressCharLists() {
        this.CompressChoices();
        RCharacterList curCharList = null;
        int i = 0;
        while (i < this.choices.size()) {
            RegularExpression curRE = (RegularExpression)this.choices.elementAt(i);
            while (curRE instanceof RJustName) {
                curRE = ((RJustName)curRE).regexpr;
            }
            if (curRE instanceof RStringLiteral && ((RStringLiteral)curRE).image.length() == 1) {
                curRE = new RCharacterList(((RStringLiteral)curRE).image.charAt(0));
                this.choices.setElementAt(curRE, i);
            }
            if (curRE instanceof RCharacterList) {
                if (((RCharacterList)curRE).negated_list) {
                    ((RCharacterList)curRE).RemoveNegation();
                }
                Vector tmp = ((RCharacterList)curRE).descriptors;
                if (curCharList == null) {
                    curCharList = new RCharacterList();
                    curRE = curCharList;
                    this.choices.setElementAt(curCharList, i);
                } else {
                    this.choices.removeElementAt(i--);
                }
                int j = tmp.size();
                while (j-- > 0) {
                    curCharList.descriptors.addElement(tmp.elementAt(j));
                }
            }
            ++i;
        }
    }

    void CompressChoices() {
        int i = 0;
        while (i < this.choices.size()) {
            RegularExpression curRE = (RegularExpression)this.choices.elementAt(i);
            while (curRE instanceof RJustName) {
                curRE = ((RJustName)curRE).regexpr;
            }
            if (curRE instanceof RChoice) {
                this.choices.removeElementAt(i--);
                int j = ((RChoice)curRE).choices.size();
                while (j-- > 0) {
                    this.choices.addElement(((RChoice)curRE).choices.elementAt(j));
                }
            }
            ++i;
        }
    }

    public void CheckUnmatchability() {
        int numStrings = 0;
        int i = 0;
        while (i < this.choices.size()) {
            RegularExpression curRE = (RegularExpression)this.choices.elementAt(i);
            if (!curRE.private_rexp && curRE.ordinal > 0 && curRE.ordinal < this.ordinal && LexGen.lexStates[curRE.ordinal] == LexGen.lexStates[this.ordinal]) {
                if (this.label != null) {
                    JavaCCErrors.warning(this, "Regular Expression choice : " + curRE.label + " can never be matched as : " + this.label);
                } else {
                    JavaCCErrors.warning(this, "Regular Expression choice : " + curRE.label + " can never be matched as token of kind : " + this.ordinal);
                }
            }
            if (!curRE.private_rexp && curRE instanceof RStringLiteral) {
                ++numStrings;
            }
            ++i;
        }
    }
}

