/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javacc.parser.JavaCCErrors;

public class Options {
    protected static Map optionValues = null;
    private static Set cmdLineSetting = null;
    private static Set inputFileSetting = null;

    protected Options() {
    }

    protected static int intValue(String option) {
        return (Integer)optionValues.get(option);
    }

    protected static boolean booleanValue(String option) {
        return (Boolean)optionValues.get(option);
    }

    protected static String stringValue(String option) {
        return (String)optionValues.get(option);
    }

    public static void init() {
        optionValues = new HashMap();
        cmdLineSetting = new HashSet();
        inputFileSetting = new HashSet();
        optionValues.put("LOOKAHEAD", new Integer(1));
        optionValues.put("CHOICE_AMBIGUITY_CHECK", new Integer(2));
        optionValues.put("OTHER_AMBIGUITY_CHECK", new Integer(1));
        optionValues.put("STATIC", Boolean.FALSE);
        optionValues.put("DEBUG_PARSER", Boolean.FALSE);
        optionValues.put("DEBUG_LOOKAHEAD", Boolean.FALSE);
        optionValues.put("DEBUG_TOKEN_MANAGER", Boolean.FALSE);
        optionValues.put("ERROR_REPORTING", Boolean.TRUE);
        optionValues.put("JAVA_UNICODE_ESCAPE", Boolean.FALSE);
        optionValues.put("UNICODE_INPUT", Boolean.FALSE);
        optionValues.put("IGNORE_CASE", Boolean.FALSE);
        optionValues.put("USER_TOKEN_MANAGER", Boolean.FALSE);
        optionValues.put("USER_CHAR_STREAM", Boolean.FALSE);
        optionValues.put("BUILD_PARSER", Boolean.TRUE);
        optionValues.put("BUILD_TOKEN_MANAGER", Boolean.TRUE);
        optionValues.put("TOKEN_MANAGER_USES_PARSER", Boolean.FALSE);
        optionValues.put("SANITY_CHECK", Boolean.TRUE);
        optionValues.put("FORCE_LA_CHECK", Boolean.FALSE);
        optionValues.put("COMMON_TOKEN_ACTION", Boolean.FALSE);
        optionValues.put("CACHE_TOKENS", Boolean.FALSE);
        optionValues.put("KEEP_LINE_COLUMN", Boolean.TRUE);
        optionValues.put("OUTPUT_DIRECTORY", ".");
        optionValues.put("JDK_VERSION", "1.4");
    }

    public static boolean isOption(String opt) {
        return opt != null && opt.length() > 1 && opt.charAt(0) == '-';
    }

    public static void setInputFileOption(Object nameloc, Object valueloc, String name, int value) {
        String s = name.toUpperCase();
        if (!optionValues.containsKey(s)) {
            JavaCCErrors.warning(nameloc, "Bad option name \"" + name + "\".  Option setting will be ignored.");
            return;
        }
        Object Val = optionValues.get(s);
        if (Val != null) {
            if (!(Val instanceof Integer) || value <= 0) {
                JavaCCErrors.warning(valueloc, "Bad option value \"" + value + "\" for \"" + name + "\".  Option setting will be ignored.");
                return;
            }
            if (inputFileSetting.contains(s)) {
                JavaCCErrors.warning(nameloc, "Duplicate option setting for \"" + name + "\" will be ignored.");
                return;
            }
            if (cmdLineSetting.contains(s)) {
                if ((Integer)Val != value) {
                    JavaCCErrors.warning(nameloc, "Command line setting of \"" + name + "\" modifies option value in file.");
                }
                return;
            }
        }
        optionValues.put(s, new Integer(value));
        inputFileSetting.add(s);
    }

    public static void setInputFileOption(Object nameloc, Object valueloc, String name, boolean value) {
        String s = name.toUpperCase();
        if (!optionValues.containsKey(s)) {
            JavaCCErrors.warning(nameloc, "Bad option name \"" + name + "\".  Option setting will be ignored.");
            return;
        }
        Object Val = optionValues.get(s);
        if (Val != null) {
            if (!(Val instanceof Boolean)) {
                JavaCCErrors.warning(valueloc, "Bad option value \"" + value + "\" for \"" + name + "\".  Option setting will be ignored.");
                return;
            }
            if (inputFileSetting.contains(s)) {
                JavaCCErrors.warning(nameloc, "Duplicate option setting for \"" + name + "\" will be ignored.");
                return;
            }
            if (cmdLineSetting.contains(s)) {
                if ((Boolean)Val != value) {
                    JavaCCErrors.warning(nameloc, "Command line setting of \"" + name + "\" modifies option value in file.");
                }
                return;
            }
        }
        optionValues.put(s, value ? Boolean.TRUE : Boolean.FALSE);
        inputFileSetting.add(s);
    }

    public static void setInputFileOption(Object nameloc, Object valueloc, String name, String value) {
        String s = name.toUpperCase();
        if (!optionValues.containsKey(s)) {
            JavaCCErrors.warning(nameloc, "Bad option name \"" + name + "\".  Option setting will be ignored.");
            return;
        }
        Object Val = optionValues.get(s);
        if (Val != null) {
            if (!(Val instanceof String)) {
                JavaCCErrors.warning(valueloc, "Bad option value \"" + value + "\" for \"" + name + "\".  Option setting will be ignored.");
                return;
            }
            if (inputFileSetting.contains(s)) {
                JavaCCErrors.warning(nameloc, "Duplicate option setting for \"" + name + "\" will be ignored.");
                return;
            }
            if (cmdLineSetting.contains(s)) {
                if (!Val.equals(value)) {
                    JavaCCErrors.warning(nameloc, "Command line setting of \"" + name + "\" modifies option value in file.");
                }
                return;
            }
        }
        optionValues.put(s, value);
        inputFileSetting.add(s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setCmdLineOption(String arg) {
        Object Val;
        String name;
        String s = arg.toUpperCase();
        int index = 0;
        while (index < s.length() && s.charAt(index) != '=' && s.charAt(index) != ':') {
            ++index;
        }
        if (index < 2 || index >= s.length() - 1) {
            if (index != s.length()) {
                System.out.println("Warning: Bad option \"" + arg + "\" will be ignored.");
                return;
            }
            if (s.length() > 3 && s.charAt(1) == 'N' && s.charAt(2) == 'O') {
                name = s.substring(3);
                Val = Boolean.FALSE;
            } else {
                name = s.substring(1);
                Val = Boolean.TRUE;
            }
        } else {
            block17: {
                if (s.substring(index + 1).equals("TRUE")) {
                    Val = Boolean.TRUE;
                } else if (s.substring(index + 1).equals("FALSE")) {
                    Val = Boolean.FALSE;
                } else {
                    try {
                        int i = Integer.parseInt(s.substring(index + 1));
                        if (i <= 0) {
                            System.out.println("Warning: Bad option value in \"" + arg + "\" will be ignored.");
                            return;
                        }
                        Val = new Integer(i);
                    }
                    catch (NumberFormatException e) {
                        Val = arg.substring(index + 1);
                        if (arg.length() <= index + 2 || arg.charAt(index + 1) != '\"' || arg.charAt(arg.length() - 1) != '\"') break block17;
                        Val = arg.substring(index + 2, arg.length() - 1);
                    }
                }
            }
            name = s.substring(1, index);
        }
        if (!optionValues.containsKey(name)) {
            System.out.println("Warning: Bad option \"" + arg + "\" will be ignored.");
            return;
        }
        Object valOrig = optionValues.get(name);
        if (Val.getClass() != valOrig.getClass()) {
            System.out.println("Warning: Bad option value in \"" + arg + "\" will be ignored.");
            return;
        }
        if (cmdLineSetting.contains(name)) {
            System.out.println("Warning: Duplicate option setting \"" + arg + "\" will be ignored.");
            return;
        }
        optionValues.put(name, Val);
        cmdLineSetting.add(name);
    }

    public static void normalize() {
        if (Options.getDebugLookahead() && !Options.getDebugParser()) {
            if (cmdLineSetting.contains("DEBUG_PARSER") || inputFileSetting.contains("DEBUG_PARSER")) {
                JavaCCErrors.warning("True setting of option DEBUG_LOOKAHEAD overrides false setting of option DEBUG_PARSER.");
            }
            optionValues.put("DEBUG_PARSER", Boolean.TRUE);
        }
    }

    public static int getLookahead() {
        return Options.intValue("LOOKAHEAD");
    }

    public static int getChoiceAmbiguityCheck() {
        return Options.intValue("CHOICE_AMBIGUITY_CHECK");
    }

    public static int getOtherAmbiguityCheck() {
        return Options.intValue("OTHER_AMBIGUITY_CHECK");
    }

    public static boolean getStatic() {
        return Options.booleanValue("STATIC");
    }

    public static boolean getDebugParser() {
        return Options.booleanValue("DEBUG_PARSER");
    }

    public static boolean getDebugLookahead() {
        return Options.booleanValue("DEBUG_LOOKAHEAD");
    }

    public static boolean getDebugTokenManager() {
        return Options.booleanValue("DEBUG_TOKEN_MANAGER");
    }

    public static boolean getErrorReporting() {
        return Options.booleanValue("ERROR_REPORTING");
    }

    public static boolean getJavaUnicodeEscape() {
        return Options.booleanValue("JAVA_UNICODE_ESCAPE");
    }

    public static boolean getUnicodeInput() {
        return Options.booleanValue("UNICODE_INPUT");
    }

    public static boolean getIgnoreCase() {
        return Options.booleanValue("IGNORE_CASE");
    }

    public static boolean getUserTokenManager() {
        return Options.booleanValue("USER_TOKEN_MANAGER");
    }

    public static boolean getUserCharStream() {
        return true;
    }

    public static boolean getBuildParser() {
        return Options.booleanValue("BUILD_PARSER");
    }

    public static boolean getBuildTokenManager() {
        return Options.booleanValue("BUILD_TOKEN_MANAGER");
    }

    public static boolean getTokenManagerUsesParser() {
        return Options.booleanValue("TOKEN_MANAGER_USES_PARSER");
    }

    public static boolean getSanityCheck() {
        return Options.booleanValue("SANITY_CHECK");
    }

    public static boolean getForceLaCheck() {
        return Options.booleanValue("FORCE_LA_CHECK");
    }

    public static boolean getCommonTokenAction() {
        return Options.booleanValue("COMMON_TOKEN_ACTION");
    }

    public static boolean getCacheTokens() {
        return Options.booleanValue("CACHE_TOKENS");
    }

    public static boolean getKeepLineColumn() {
        return Options.booleanValue("KEEP_LINE_COLUMN");
    }

    public static String getJdkVersion() {
        return Options.stringValue("JDK_VERSION");
    }

    public static File getOutputDirectory() {
        return new File(Options.stringValue("OUTPUT_DIRECTORY"));
    }
}

