/*
 * Decompiled with CFR 0.152.
 */
package modification.traversalLanguageParser.addressManagement;

import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import modification.traversalLanguageParser.addressManagement.TreeAddressToken;

public class NameTypePatternToken
extends TreeAddressToken {
    private String namePattern;
    private String typePattern;

    @Override
    public List<FSTNode> getPossibleMatchingFollowUps(FSTNode node) {
        if (node instanceof FSTNonTerminal) {
            return ((FSTNonTerminal)node).getChildren();
        }
        return null;
    }

    @Override
    public List<FSTNode> getMatchingNodes(FSTNode node) {
        LinkedList<FSTNode> list = new LinkedList<FSTNode>();
        if (Pattern.matches(this.namePattern, node.getName()) && Pattern.matches(this.typePattern, node.getType())) {
            list.add(node);
            return list;
        }
        return null;
    }

    public NameTypePatternToken(String namePattern, String typePattern) {
        this.namePattern = namePattern;
        this.typePattern = typePattern;
    }

    public String toString() {
        return "namePattern: " + this.namePattern + " typePattern: " + this.typePattern;
    }
}

