/*
 * Decompiled with CFR 0.152.
 */
package modification.content;

import java.io.File;
import modification.content.Content;
import modification.content.Parseables.C.CFile;
import modification.content.Parseables.C.CFunction;
import modification.content.Parseables.CSharp.CSharpFile;
import modification.content.Parseables.CSharp.CSharpInterfaceMemberDeclaration;
import modification.content.Parseables.CSharp.CSharpMethod;
import modification.content.Parseables.haskell.HaskellDefinition;
import modification.content.Parseables.haskell.HaskellFile;
import modification.content.Parseables.java.JavaFile;
import modification.content.Parseables.java.JavaMethod;
import modification.content.Parseables.java.JavaMethodBody;
import modification.content.UnknownContentTypeParseException;
import modification.content.UnknownFileTypeParseException;

public class ContentGenerator {
    public static Content createContent(File file) throws UnknownFileTypeParseException {
        if (file.getName().endsWith("java")) {
            return new JavaFile(file);
        }
        if (file.getName().endsWith("c")) {
            return new CFile(file);
        }
        if (file.getName().endsWith("hs")) {
            return new HaskellFile(file);
        }
        if (file.getName().endsWith("cs")) {
            return new CSharpFile(file);
        }
        System.out.println("> " + file.getName());
        throw new UnknownFileTypeParseException();
    }

    public static Content createContent(String type, String content) throws UnknownContentTypeParseException {
        if (type.equals("java.method")) {
            return new JavaMethod(content);
        }
        if (type.equals("c.function")) {
            return new CFunction(content);
        }
        if (type.equals("haskell.definition")) {
            return new HaskellDefinition(content);
        }
        if (type.equals("cSharp.method")) {
            return new CSharpMethod(content);
        }
        if (type.equals("java.methodBody")) {
            return new JavaMethodBody(content);
        }
        if (type.equals("cSharp.interfaceMemberDeclaration")) {
            return new CSharpInterfaceMemberDeclaration(content);
        }
        throw new UnknownContentTypeParseException();
    }
}

