/*
 * Decompiled with CFR 0.152.
 */
package merger;

import de.ovgu.cide.fstgen.ast.FSTTerminal;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import merger.ContentMergeException;
import merger.MergerInterface;

public class LineBasedMerger
implements MergerInterface {
    String encoding = "UTF-8";

    @Override
    public void merge(FSTTerminal node) throws ContentMergeException {
        String body = String.valueOf(node.getBody()) + " ";
        String[] tokens = body.split("##FSTMerge##");
        try {
            tokens[0] = tokens[0].replace("~~FSTMerge~~", "").trim();
            tokens[1] = tokens[1].trim();
            tokens[2] = tokens[2].trim();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("|" + body + "|");
            e.printStackTrace();
        }
        if (!node.getType().contains("-Content") && !node.getMergingMechanism().equals("LineBased")) {
            if (tokens[0].length() == 0 && tokens[1].length() == 0 && tokens[2].length() == 0) {
                node.setBody("");
            } else if (tokens[0].equals(tokens[2])) {
                node.setBody(tokens[0]);
            } else if (tokens[0].equals(tokens[1]) && tokens[2].length() > 0) {
                node.setBody(tokens[2]);
            } else if (tokens[2].equals(tokens[1]) && tokens[0].length() > 0) {
                node.setBody(tokens[0]);
            } else if (tokens[0].equals(tokens[1]) && tokens[2].length() == 0) {
                node.setBody("");
            } else if (tokens[2].equals(tokens[1]) && tokens[0].length() == 0) {
                node.setBody("");
            }
            return;
        }
        try {
            long time = System.currentTimeMillis();
            File tmpDir = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "fstmerge_tmp" + time);
            tmpDir.mkdir();
            File fileVar1 = File.createTempFile("fstmerge_var1_", "", tmpDir);
            File fileBase = File.createTempFile("fstmerge_base_", "", tmpDir);
            File fileVar2 = File.createTempFile("fstmerge_var2_", "", tmpDir);
            BufferedWriter writerVar1 = new BufferedWriter(new FileWriter(fileVar1));
            if (node.getType().contains("-Content") || tokens[0].length() == 0) {
                writerVar1.write(tokens[0]);
            } else {
                writerVar1.write(String.valueOf(tokens[0]) + "\n");
            }
            writerVar1.close();
            BufferedWriter writerBase = new BufferedWriter(new FileWriter(fileBase));
            if (node.getType().contains("-Content") || tokens[1].length() == 0) {
                writerBase.write(tokens[1]);
            } else {
                writerBase.write(String.valueOf(tokens[1]) + "\n");
            }
            writerBase.close();
            BufferedWriter writerVar2 = new BufferedWriter(new FileWriter(fileVar2));
            if (node.getType().contains("-Content") || tokens[2].length() == 0) {
                writerVar2.write(tokens[2]);
            } else {
                writerVar2.write(String.valueOf(tokens[2]) + "\n");
            }
            writerVar2.close();
            String mergeCmd = "";
            mergeCmd = System.getProperty("os.name").contains("Windows") ? "C:\\Programme\\cygwin\\bin\\merge.exe -q -p \"" + fileVar1.getPath() + "\"" + " " + "\"" + fileBase.getPath() + "\"" + " " + "\"" + fileVar2.getPath() + "\"" : "merge -q -p " + fileVar1.getPath() + " " + fileBase.getPath() + " " + fileVar2.getPath();
            Runtime run = Runtime.getRuntime();
            Process pr = run.exec(mergeCmd);
            BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = "";
            String res = "";
            while ((line = buf.readLine()) != null) {
                res = String.valueOf(res) + line + "\n";
            }
            pr.getInputStream().close();
            node.setBody(res);
            buf = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            while ((line = buf.readLine()) != null) {
                System.err.println(line);
            }
            pr.getErrorStream().close();
            pr.getOutputStream().close();
            fileVar1.delete();
            fileBase.delete();
            fileVar2.delete();
            tmpDir.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

