/*
 * Decompiled with CFR 0.152.
 */
package merger;

import builder.ArtifactBuilderInterface;
import builder.csharp.CSharpBuilder;
import builder.csharpm.CSharpMergeBuilder;
import builder.java.JavaBuilder;
import builder.javam.JavaMergeBuilder;
import builder.pythonm.PythonMergeBuilder;
import builder.textm.TextMergeBuilder;
import cide.gparser.ParseException;
import composer.FSTGenProcessor;
import de.ovgu.cide.fstgen.ast.AbstractFSTParser;
import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import de.ovgu.cide.fstgen.ast.FSTTerminal;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import merger.CmdLineInterpreter;
import merger.LineBasedMerger;
import merger.MergeException;
import merger.MergeVisitor;
import printer.PrintVisitorException;
import printer.PrintVisitorInterface;
import printer.csharp.CSharpPrintVisitor;
import printer.csharpm.CSharpMergePrintVisitor;
import printer.java.JavaPrintVisitor;
import printer.javam.JavaMergePrintVisitor;
import printer.pythonm.PythonMergePrintVisitor;
import printer.textm.TextMergePrintVisitor;

public class FSTGenMerger
extends FSTGenProcessor {
    static final String MERGE_SEPARATOR = "##FSTMerge##";
    static final String SEMANTIC_MERGE_MARKER = "~~FSTMerge~~";
    private CmdLineInterpreter cmd = new CmdLineInterpreter();
    private static LinkedList<FSTNode> baseNodes = new LinkedList();
    private MergeVisitor mergeVisitor = new MergeVisitor();

    public FSTGenMerger() {
        this.mergeVisitor.registerMerger(new LineBasedMerger());
        ArtifactBuilderInterface stdJavaBuilder = null;
        ArtifactBuilderInterface stdCSharpBuilder = null;
        for (ArtifactBuilderInterface builder : this.getArtifactBuilders()) {
            if (builder instanceof JavaBuilder) {
                stdJavaBuilder = builder;
            }
            if (!(builder instanceof CSharpBuilder)) continue;
            stdCSharpBuilder = builder;
        }
        this.unregisterArtifactBuilder(stdJavaBuilder);
        this.unregisterArtifactBuilder(stdCSharpBuilder);
        this.registerArtifactBuilder(new JavaMergeBuilder());
        this.registerArtifactBuilder(new CSharpMergeBuilder());
        this.registerArtifactBuilder(new PythonMergeBuilder());
        this.registerArtifactBuilder(new TextMergeBuilder(".java"));
        this.registerArtifactBuilder(new TextMergeBuilder(".cs"));
        this.registerArtifactBuilder(new TextMergeBuilder(".py"));
        PrintVisitorInterface stdJavaPrinter = null;
        PrintVisitorInterface stdCSharpPrinter = null;
        for (PrintVisitorInterface printer : this.getPrintVisitors()) {
            if (printer instanceof JavaPrintVisitor) {
                stdJavaPrinter = printer;
            }
            if (!(printer instanceof CSharpPrintVisitor)) continue;
            stdCSharpPrinter = printer;
        }
        this.unregisterPrintVisitor(stdJavaPrinter);
        this.unregisterPrintVisitor(stdCSharpPrinter);
        this.registerPrintVisitor(new JavaMergePrintVisitor());
        this.registerPrintVisitor(new CSharpMergePrintVisitor());
        this.registerPrintVisitor(new PythonMergePrintVisitor());
        this.registerPrintVisitor(new TextMergePrintVisitor(".java"));
        this.registerPrintVisitor(new TextMergePrintVisitor(".cs"));
        this.registerPrintVisitor(new TextMergePrintVisitor(".py"));
    }

    public void run(String[] args) {
        this.cmd.parseCmdLineArguments(args);
        try {
            try {
                if (this.cmd.preprocessFiles) {
                    this.fileLoader.setPreprocessFiles(true);
                }
                this.fileLoader.loadFiles(this.cmd.equationFileName, this.cmd.equationBaseDirectoryName, false);
            }
            catch (ParseException e1) {
                this.fireParseErrorOccured(e1);
                e1.printStackTrace();
            }
            String outputDir = this.cmd.equationBaseDirectoryName;
            if (this.cmd.outputDirectoryName != null) {
                outputDir = this.cmd.outputDirectoryName;
            }
            this.featureVisitor.setWorkingDir(outputDir);
            this.featureVisitor.setExpressionName(this.cmd.equationFileName);
            for (ArtifactBuilderInterface builder : this.getArtifactBuilders()) {
                LinkedList<FSTNonTerminal> features = builder.getFeatures();
                for (FSTNonTerminal feature : features) {
                    System.out.println(feature.toString());
                }
                if (features.size() == 0) continue;
                FSTNode merged = FSTGenMerger.merge(features);
                this.mergeVisitor.visit(merged);
                System.err.println(merged.toString());
                try {
                    this.featureVisitor.visit((FSTNonTerminal)merged);
                }
                catch (PrintVisitorException e) {
                    e.printStackTrace();
                }
            }
            this.setFstnodes(AbstractFSTParser.fstnodes);
        }
        catch (MergeException me) {
            System.err.println(me.toString());
            me.printStackTrace();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FSTGenMerger merger = new FSTGenMerger();
        merger.run(args);
    }

    private static FSTNode merge(List<FSTNonTerminal> tl) throws MergeException {
        if (tl.size() != 3) {
            throw new MergeException(tl);
        }
        tl.get((int)0).index = 0;
        tl.get((int)1).index = 1;
        tl.get((int)2).index = 2;
        FSTNode mergeLeftBase = FSTGenMerger.merge(tl.get(0), tl.get(1), true);
        FSTNode mergeLeftBaseRight = FSTGenMerger.merge(mergeLeftBase, tl.get(2), false);
        FSTGenMerger.removeLoneBaseNodes(mergeLeftBaseRight);
        return mergeLeftBaseRight;
    }

    public static FSTNode merge(FSTNode nodeA, FSTNode nodeB, boolean firstPass) {
        return FSTGenMerger.merge(nodeA, nodeB, null, firstPass);
    }

    public static FSTNode merge(FSTNode nodeA, FSTNode nodeB, FSTNode compParent, boolean firstPass) {
        if (nodeA.compatibleWith(nodeB)) {
            FSTNode compNode = nodeA.getShallowClone();
            compNode.index = nodeB.index;
            compNode.setParent(compParent);
            if (nodeA instanceof FSTNonTerminal && nodeB instanceof FSTNonTerminal) {
                FSTNonTerminal nonterminalA = (FSTNonTerminal)nodeA;
                FSTNonTerminal nonterminalB = (FSTNonTerminal)nodeB;
                FSTNonTerminal nonterminalComp = (FSTNonTerminal)compNode;
                for (FSTNode childB : nonterminalB.getChildren()) {
                    FSTNode childA = nonterminalA.getCompatibleChild(childB);
                    if (childA == null) {
                        FSTNode cloneB = childB.getDeepClone();
                        if (childB.index == -1) {
                            childB.index = nodeB.index;
                        }
                        cloneB.index = childB.index;
                        nonterminalComp.addChild(cloneB);
                        if (!firstPass) continue;
                        baseNodes.add(cloneB);
                        continue;
                    }
                    if (childA.index == -1) {
                        childA.index = nodeA.index;
                    }
                    if (childB.index == -1) {
                        childB.index = nodeB.index;
                    }
                    nonterminalComp.addChild(FSTGenMerger.merge(childA, childB, nonterminalComp, firstPass));
                }
                for (FSTNode childA : nonterminalA.getChildren()) {
                    FSTNode childB = nonterminalB.getCompatibleChild(childA);
                    if (childB == null) {
                        FSTNode cloneA = childA.getDeepClone();
                        if (childA.index == -1) {
                            childA.index = nodeA.index;
                        }
                        cloneA.index = childA.index;
                        nonterminalComp.addChild(cloneA);
                        if (!baseNodes.contains(childA)) continue;
                        baseNodes.remove(childA);
                        baseNodes.add(cloneA);
                        continue;
                    }
                    if (firstPass) continue;
                    baseNodes.remove(childA);
                }
                return nonterminalComp;
            }
            if (nodeA instanceof FSTTerminal && nodeB instanceof FSTTerminal && compParent instanceof FSTNonTerminal) {
                FSTTerminal terminalA = (FSTTerminal)nodeA;
                FSTTerminal terminalB = (FSTTerminal)nodeB;
                FSTTerminal terminalComp = (FSTTerminal)compNode;
                if (!terminalA.getMergingMechanism().equals("Default")) {
                    terminalComp.setBody(FSTGenMerger.mergeBody(terminalA.getBody(), terminalB.getBody(), firstPass, terminalA.index, terminalB.index));
                }
                return terminalComp;
            }
            return null;
        }
        return null;
    }

    private static String mergeBody(String bodyA, String bodyB, boolean firstPass, int indexA, int indexB) {
        if (bodyA.contains(SEMANTIC_MERGE_MARKER)) {
            return String.valueOf(bodyA) + " " + bodyB;
        }
        if (firstPass) {
            return "~~FSTMerge~~ " + bodyA + " " + MERGE_SEPARATOR + " " + bodyB + " " + MERGE_SEPARATOR;
        }
        if (indexA == 0) {
            return "~~FSTMerge~~ " + bodyA + " " + MERGE_SEPARATOR + " " + MERGE_SEPARATOR + " " + bodyB;
        }
        return "~~FSTMerge~~ ##FSTMerge## " + bodyA + " " + MERGE_SEPARATOR + " " + bodyB;
    }

    private static void removeLoneBaseNodes(FSTNode mergeLeftBaseRight) {
        boolean removed = false;
        for (FSTNode loneBaseNode : baseNodes) {
            FSTNonTerminal parent;
            if (mergeLeftBaseRight != loneBaseNode || (parent = (FSTNonTerminal)mergeLeftBaseRight.getParent()) == null) continue;
            parent.removeChild(mergeLeftBaseRight);
            removed = true;
        }
        if (!removed && mergeLeftBaseRight instanceof FSTNonTerminal) {
            Object[] children;
            Object[] objectArray = children = ((FSTNonTerminal)mergeLeftBaseRight).getChildren().toArray();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                FSTGenMerger.removeLoneBaseNodes((FSTNode)child);
                ++n2;
            }
        }
    }
}

