/*
 * Decompiled with CFR 0.152.
 */
package merger;

import java.io.File;

public class CmdLineInterpreter {
    public static final String INPUT_OPTION_EQUATIONFILE = "--expression";
    public static final String INPUT_OPTION_BASE_DIRECTORY = "--base-directory";
    public static final String INPUT_OPTION_OUTPUT_DIRECTORY = "--output-directory";
    public static final String INPUT_OPTION_PREPROCESS_FILES = "--preprocess-files";
    public static final String INPUT_OPTION_HELP = "--help";
    public String equationFileName;
    public String equationBaseDirectoryName;
    public String outputDirectoryName = null;
    public boolean preprocessFiles = false;
    public boolean isBaseDirectoryName = false;

    public void parseCmdLineArguments(String[] args) {
        boolean errorOccured = false;
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals(INPUT_OPTION_EQUATIONFILE)) {
                    if (++i < args.length) {
                        this.equationFileName = args[i];
                        if (!this.isBaseDirectoryName) {
                            this.equationBaseDirectoryName = String.valueOf(CmdLineInterpreter.getDirectoryName(new File(this.equationFileName))) + File.separator;
                        }
                        this.equationFileName = this.equationFileName.replace("\\", File.separator);
                        this.equationFileName = this.equationFileName.replace("/", File.separator);
                    } else {
                        System.out.println("Error occured option: --expression");
                        errorOccured = true;
                    }
                } else if (args[i].equals(INPUT_OPTION_BASE_DIRECTORY)) {
                    if (++i < args.length) {
                        this.equationBaseDirectoryName = args[i];
                        this.equationBaseDirectoryName = this.equationBaseDirectoryName.replace("\\", File.separator);
                        this.equationBaseDirectoryName = this.equationBaseDirectoryName.replace("/", File.separator);
                        this.isBaseDirectoryName = true;
                    } else {
                        System.out.println("Error occured option: --base-directory");
                        errorOccured = true;
                    }
                } else if (args[i].equals(INPUT_OPTION_OUTPUT_DIRECTORY)) {
                    if (++i < args.length) {
                        this.outputDirectoryName = args[i];
                    } else {
                        System.out.println("Error occured option: --output-directory");
                        errorOccured = true;
                    }
                } else if (args[i].equals(INPUT_OPTION_PREPROCESS_FILES)) {
                    if (++i < args.length) {
                        this.preprocessFiles = Boolean.parseBoolean(args[i]);
                    } else {
                        System.out.println("Error occured option: --preprocess-files");
                        errorOccured = true;
                    }
                } else if (args[i].equals(INPUT_OPTION_HELP)) {
                    CmdLineInterpreter.printHelp(false);
                } else {
                    errorOccured = true;
                }
                ++i;
            }
        } else {
            errorOccured = true;
        }
        if (errorOccured) {
            CmdLineInterpreter.printHelp(errorOccured);
        }
    }

    private static void printHelp(boolean errorOccured) {
        if (errorOccured) {
            System.out.println("Insufficient command line parameters!");
        }
        System.out.println("Use `java -jar SemiStructuredMerger-<VERSION>.jar --expression <file name> [--base-directory <directory name>]'");
        System.out.println("The option `--expression' defines the name of the file that lists the input features/components.");
        System.out.println("The option `--base-directory' defines the working directory, which is the search path for the input features/components.");
    }

    private static String getDirectoryName(File file) {
        String result = "";
        result = file.isDirectory() ? file.getPath() : file.getAbsoluteFile().getParentFile().getPath();
        return result;
    }
}

