/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.cide.fstgen.ast;

import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTVisitor;

public class FSTTerminal
extends FSTNode {
    public static final String defaultCompositionMechanism = "Replacement";
    public static final String defaultMergingMechanism = "Default";
    private String body;
    private String compose = "Replacement";
    private String merge = "Default";
    private String prefix;

    public FSTTerminal(String type, String name, String body, String prefix) {
        super(type, name);
        this.body = body;
        this.prefix = prefix;
    }

    public FSTTerminal(String type, String name, String body, String prefix, String compositionMechanism) {
        this(type, name, body, prefix);
        this.compose = compositionMechanism;
    }

    public FSTTerminal(String type, String name, String body, String prefix, String compositionMechanism, String mergingMechanism) {
        this(type, name, body, prefix, compositionMechanism);
        this.merge = mergingMechanism;
    }

    public String getSpecialTokenPrefix() {
        return this.prefix;
    }

    public FSTNode getShallowClone() {
        return new FSTTerminal(this.getType(), this.getName(), this.getBody(), this.getSpecialTokenPrefix(), this.getCompositionMechanism(), this.getMergingMechanism());
    }

    public FSTNode getDeepClone() {
        return new FSTTerminal(this.getType(), this.getName(), this.getBody(), this.getSpecialTokenPrefix(), this.getCompositionMechanism(), this.getMergingMechanism());
    }

    public void setBody(String b) {
        this.body = b;
    }

    public String getBody() {
        return this.body;
    }

    public String getCompositionMechanism() {
        return this.compose;
    }

    public String getMergingMechanism() {
        return this.merge;
    }

    public String toString() {
        return "[T -> " + this.getName() + " : " + this.getType() + " \"" + (this.body.length() != 0 ? this.body.replaceAll("\\s", " ") : "") + "\" compose:" + this.compose + " merge: " + this.merge + "]";
    }

    public String printFST(int indent) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < indent) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(this.toString());
        buffer.append("\n");
        return buffer.toString();
    }

    public void accept(FSTVisitor visitor) {
        visitor.visit(this);
        visitor.postVisit(this);
    }

    public void setCompositionMechanism(String compositionMechanism) {
        this.compose = compositionMechanism;
    }

    public void setMergingMechanism(String mergingMechanism) {
        this.merge = mergingMechanism;
    }
}

