/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.cide.fstgen.ast;

import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTVisitor;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSTNonTerminal
extends FSTNode {
    private List<FSTNode> children;
    private static int level = 0;

    public FSTNonTerminal(String type, String name) {
        super(type, name);
        this.children = new LinkedList<FSTNode>();
    }

    public FSTNonTerminal(String type, String name, List<FSTNode> children) {
        super(type, name);
        this.children = children;
        for (FSTNode child : children) {
            child.setParent(this);
        }
    }

    @Override
    public FSTNode getShallowClone() {
        return new FSTNonTerminal(this.getType(), this.getName(), new LinkedList<FSTNode>());
    }

    @Override
    public FSTNode getDeepClone() {
        LinkedList<FSTNode> cloneChildren = new LinkedList<FSTNode>();
        for (FSTNode child : this.getChildren()) {
            cloneChildren.add(child.getDeepClone());
        }
        return new FSTNonTerminal(this.getType(), this.getName(), cloneChildren);
    }

    public List<FSTNode> getChildren() {
        return this.children;
    }

    public void addChild(FSTNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public FSTNode getCompatibleChild(FSTNode node) {
        for (FSTNode child : this.getChildren()) {
            if (!child.compatibleWith(node)) continue;
            return child;
        }
        return null;
    }

    public String toStringShort() {
        return "[NT -> " + this.getName() + " : " + this.getType() + "]";
    }

    public String toString() {
        String shortS = this.toStringShort();
        return String.valueOf(shortS) + this.printChildrenList();
    }

    private String printChildrenList() {
        ++level;
        String result = "";
        int idx = 0;
        while (idx < this.children.size()) {
            result = String.valueOf(result) + "\n";
            int i = 0;
            while (i < level) {
                result = String.valueOf(result) + "\t";
                ++i;
            }
            result = String.valueOf(result) + this.children.get(idx).toString();
            ++idx;
        }
        --level;
        return String.valueOf(result) + "]";
    }

    @Override
    public String printFST(int indent) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < indent) {
            buffer.append("    ");
            ++i;
        }
        buffer.append(this.toStringShort());
        buffer.append("\n");
        for (FSTNode n : this.children) {
            buffer.append(n.printFST(indent + 1));
        }
        return buffer.toString();
    }

    @Override
    public void accept(FSTVisitor visitor) {
        boolean visitInner = visitor.visit(this);
        if (visitInner) {
            for (FSTNode child : this.children) {
                child.accept(visitor);
            }
        }
        visitor.postVisit(this);
    }

    public void removeChild(FSTNode node) {
        this.children.remove(node);
    }
}

