/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.cide.fstgen.ast;

import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import de.ovgu.cide.fstgen.ast.FSTTerminal;
import de.ovgu.cide.fstgen.ast.FSTVisitor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFSTPrintVisitor
extends FSTVisitor {
    private final StringBuffer buffer = new StringBuffer();
    private final PrintStream outputStream;
    private List<String> tokensInCurrentLine = new ArrayList<String>();
    private int indentInCurrentLine = 0;
    public boolean generateSpaces = true;
    private int indent = 0;
    private List<String> noSpaceAfterToken;
    private List<String> noSpaceBeforeToken;

    public AbstractFSTPrintVisitor(PrintStream out) {
        this.outputStream = out;
    }

    public AbstractFSTPrintVisitor() {
        this.outputStream = null;
    }

    protected void printToken(String token) {
        if (this.tokensInCurrentLine.size() == 0) {
            this.indentInCurrentLine = this.indent;
        }
        this.tokensInCurrentLine.add(token);
    }

    protected void hintIncIndent() {
        ++this.indent;
    }

    protected void hintDecIndent() {
        --this.indent;
    }

    protected void hintNewLine() {
        this.closeLine();
    }

    protected void hintSingleSpace() {
        this.printToken(" ");
    }

    private void closeLine() {
        int i = 0;
        while (i < this.indentInCurrentLine) {
            this.print('\t');
            ++i;
        }
        String lastToken = null;
        for (String token : this.tokensInCurrentLine) {
            if (this.generateSpaces && lastToken != null && !this.getNoSpaceAfterToken().contains(lastToken) && !this.getNoSpaceBeforeToken().contains(token)) {
                this.print(' ');
            }
            this.print(token);
            lastToken = token;
        }
        this.print('\n');
        this.tokensInCurrentLine.clear();
        this.indentInCurrentLine = 0;
    }

    protected void print(String s) {
        this.buffer.append(s);
        if (this.outputStream != null) {
            this.outputStream.print(s);
        }
    }

    private void print(char s) {
        this.buffer.append(s);
        if (this.outputStream != null) {
            this.outputStream.print(s);
        }
    }

    public String getResult() {
        if (this.tokensInCurrentLine.size() > 0) {
            this.closeLine();
        }
        return this.buffer.toString();
    }

    protected List<String> getNoSpaceAfterToken() {
        if (this.noSpaceAfterToken == null) {
            this.noSpaceAfterToken = new ArrayList<String>();
            this.noSpaceAfterToken.add("{");
            this.noSpaceAfterToken.add("(");
            this.noSpaceAfterToken.add("[");
            this.noSpaceAfterToken.add("@");
            this.noSpaceAfterToken.add(".");
        }
        return this.noSpaceAfterToken;
    }

    protected List<String> getNoSpaceBeforeToken() {
        if (this.noSpaceBeforeToken == null) {
            this.noSpaceBeforeToken = new ArrayList<String>();
            this.noSpaceBeforeToken.add("}");
            this.noSpaceBeforeToken.add(")");
            this.noSpaceBeforeToken.add("]");
            this.noSpaceBeforeToken.add(";");
            this.noSpaceBeforeToken.add(".");
        }
        return this.noSpaceBeforeToken;
    }

    protected abstract boolean isSubtype(String var1, String var2);

    protected List<FSTNode> getChildren(FSTNonTerminal nonTerminal, String childType) {
        ArrayList<FSTNode> result = new ArrayList<FSTNode>();
        for (FSTNode node : nonTerminal.getChildren()) {
            if (!this.isSubtype(node.getType(), childType)) continue;
            result.add(node);
        }
        return result;
    }

    protected FSTNode getChild(FSTNonTerminal nonTerminal, String childType) {
        List<FSTNode> result = this.getChildren(nonTerminal, childType);
        if (result.size() > 1) {
            throw new RuntimeException("Cannot handle multple FST nodes of type " + childType + " here (" + result.get(0).getName() + ":" + result.get(0).getType() + " and " + result.get(1).getName() + ":" + result.get(0).getType() + " parent: " + nonTerminal.toString() + ")");
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public boolean visit(FSTTerminal terminal) {
        this.printFeatures(terminal, true);
        this.printToken(String.valueOf(terminal.getSpecialTokenPrefix()) + terminal.getBody());
        this.printFeatures(terminal, false);
        return false;
    }

    protected void printFeatures(FSTNode node, boolean b) {
    }
}

