/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.cide.fstgen.ast;

import cide.gparser.Token;
import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import de.ovgu.cide.fstgen.ast.FSTTerminal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFSTParser {
    private HashMap<String, String> composeReplacements = new HashMap();
    private Stack<Context> currentContext = new Stack();
    public static ArrayList<FSTNode> fstnodes = new ArrayList();
    private static int uniqueId = 0;

    protected AbstractFSTParser() {
        this.currentContext.push(new Context(false));
    }

    private Context cc() {
        return this.currentContext.peek();
    }

    public FSTNode getRoot() {
        return this.cc().children.get(0);
    }

    protected void productionStart(boolean isInTerminal) {
        this.currentContext.push(new Context(isInTerminal));
    }

    protected FSTInfo productionEndNonTerminal(String type, String namePattern, String exportNamePattern) {
        Context c = this.currentContext.pop();
        String exportName = this.applyReplacements(exportNamePattern, c.nameReplacements, FSTInfoType.NAME);
        type = this.applyReplacements(type, c.nameReplacements, FSTInfoType.NAME);
        if (!this.cc().isInTerminal) {
            String name = namePattern.equals(exportNamePattern) ? exportName : this.applyReplacements(namePattern, c.nameReplacements, FSTInfoType.NAME);
            FSTNonTerminal nonTerminal = new FSTNonTerminal(type, name, c.children);
            fstnodes.add(nonTerminal);
            this.cc().children.add(nonTerminal);
        }
        return new FSTInfo(type, exportName);
    }

    private String applyReplacements(String name, List<Replacement> replList, FSTInfoType type) {
        for (Replacement replacement : replList) {
            String value = type == FSTInfoType.NAME ? replacement.value.exportedName : replacement.value.exportedComposition;
            String listName = "{" + replacement.productionName + "}^";
            int listStart = name.indexOf(listName);
            if (listStart >= 0) {
                char sepChar = name.charAt(listStart + listName.length());
                name = name.replace(listName, String.valueOf(value) + (sepChar == '~' ? "" : Character.valueOf(sepChar)) + listName);
                continue;
            }
            name = name.replace("{" + replacement.productionName + "}", value);
        }
        while (name.contains("{AUTO}")) {
            name = name.replace("{AUTO}", this.generateName());
        }
        name = name.replaceAll("(.)\\{[^\\{\\}]*?\\}\\^\\1", "");
        name = name.replaceAll("\\{[^\\{\\}]*?\\}\\^.", "");
        return name;
    }

    private CharSequence generateName() {
        return "auto" + ++uniqueId;
    }

    protected FSTInfo productionEndTerminal(String type, String namePattern, String exportNamePattern, String compositionMechanism, Token first, Token last) {
        return this.productionEndTerminal(type, namePattern, exportNamePattern, compositionMechanism, "Default", first, last);
    }

    protected FSTInfo productionEndTerminal(String type, String namePattern, String exportNamePattern, String compositionMechanism, String mergingMechanism, Token first, Token last) {
        Context c = this.currentContext.pop();
        String prefix = this.getPrefix(first);
        String body = this.getBody(first, last);
        c.nameReplacements.add(new Replacement("TOSTRING", new FSTInfo(type, this.stripWhitespace(body))));
        String exportName = this.applyReplacements(exportNamePattern, c.nameReplacements, FSTInfoType.NAME);
        type = this.applyReplacements(type, c.nameReplacements, FSTInfoType.NAME);
        compositionMechanism = this.applyReplacements(compositionMechanism, c.nameReplacements, FSTInfoType.COMPOSE_OR_MERGE);
        mergingMechanism = this.applyReplacements(mergingMechanism, c.nameReplacements, FSTInfoType.COMPOSE_OR_MERGE);
        if (!c.isInTerminal) {
            String name = namePattern.equals(exportNamePattern) ? exportName : this.applyReplacements(namePattern, c.nameReplacements, FSTInfoType.NAME);
            this.cc().children.addAll(c.children);
            if (first != null) {
                this.cc().children.add(new FSTTerminal(type, name, body, prefix, compositionMechanism, mergingMechanism));
            }
        }
        return new FSTInfo(type, exportName, compositionMechanism);
    }

    private String applyComposeReplacements(String compositionMechanism) {
        if (compositionMechanism.length() > 0 && compositionMechanism.charAt(0) == '{') {
            for (String productionKey : this.composeReplacements.keySet()) {
                compositionMechanism = compositionMechanism.replace("{" + productionKey + "}", this.composeReplacements.get(productionKey));
            }
        }
        return compositionMechanism;
    }

    private String stripWhitespace(String body) {
        return body.replaceAll("\\s", "");
    }

    private String getBody(Token first, Token last) {
        StringBuffer body = new StringBuffer();
        Token token = first;
        if (token != null) {
            while (token != null && token != last.next) {
                if (token.specialToken != null && token != first) {
                    body.append(this.getPrefix(token));
                }
                body.append(token.image);
                token = token.next;
            }
        }
        return body.toString();
    }

    private String getPrefix(Token token) {
        StringBuffer result = new StringBuffer();
        Token t = token.specialToken;
        while (t != null) {
            result.insert(0, t.image);
            t = t.specialToken;
        }
        return result.toString();
    }

    protected void replaceName(FSTInfo value) {
        this.cc().nameReplacements.add(new Replacement(value.type, value));
    }

    protected void replaceName(String name, FSTInfo value) {
        this.cc().nameReplacements.add(new Replacement(name, value));
    }

    private static class Context {
        List<FSTNode> children = new ArrayList<FSTNode>();
        List<Replacement> nameReplacements = new ArrayList<Replacement>();
        List<Replacement> composeReplacements = new ArrayList<Replacement>();
        boolean isInTerminal = false;

        Context(boolean isInTerminal) {
            this.isInTerminal = isInTerminal;
        }
    }

    protected static class FSTInfo {
        final String exportedName;
        final String exportedComposition;
        final String type;

        public FSTInfo(String type, String exportedName) {
            this.exportedName = exportedName;
            this.exportedComposition = "";
            this.type = type;
        }

        public FSTInfo(String type, String exportedName, String exportedComposition) {
            this.exportedName = exportedName;
            this.exportedComposition = exportedComposition;
            this.type = type;
        }

        public String toString() {
            return "[" + this.type + " - " + this.exportedName + " - " + this.exportedComposition + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FSTInfoType {
        NAME,
        COMPOSE_OR_MERGE;

    }

    private static class Replacement {
        String productionName;
        FSTInfo value;

        Replacement(String c, FSTInfo v) {
            this.productionName = c;
            this.value = v;
        }

        public String toString() {
            return String.valueOf(this.productionName) + "-" + this.value.exportedName;
        }
    }
}

