/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.cide.fstgen;

import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.parser.ParseException;
import cide.astgen.nparser.parser.SlimJJParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;

public class ParserTest
extends TestCase {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testParser() throws ParseException, FileNotFoundException {
        SlimJJParser parser = new SlimJJParser(new FileInputStream("test/fj.gcide"));
        NGrammar grammar = parser.Grammar();
    }

    @Test
    public void testParseAnnotation() throws ParseException, FileNotFoundException {
        NGrammar g = this.parse("@A main:x;");
        Assert.assertEquals((int)1, (int)g.findProduction("main").getChoices().get(0).getAnnotations().size());
        Assert.assertNotNull((Object)g.findProduction("main").getChoices().get(0).findAnnotation("A"));
        Assert.assertEquals((int)0, (int)g.findProduction((String)"main").getChoices().get((int)0).findAnnotation((String)"A").values.keySet().size());
        g = this.parse("@A() @B main:x;");
        Assert.assertEquals((int)2, (int)g.findProduction("main").getChoices().get(0).getAnnotations().size());
        Assert.assertNotNull((Object)g.findProduction("main").getChoices().get(0).findAnnotation("B"));
        g = this.parse("@A(a=1, b=2) main:x;");
        Assert.assertEquals((int)2, (int)g.findProduction((String)"main").getChoices().get((int)0).findAnnotation((String)"A").values.keySet().size());
        Assert.assertEquals((String)"1", (String)g.findProduction((String)"main").getChoices().get((int)0).findAnnotation((String)"A").values.get("a"));
        g = this.parse("@A(a=1, b=\"x\") main:x;");
        Assert.assertEquals((String)"1", (String)g.findProduction((String)"main").getChoices().get((int)0).findAnnotation((String)"A").values.get("a"));
        Assert.assertEquals((String)"\"x\"", (String)g.findProduction((String)"main").getChoices().get((int)0).findAnnotation((String)"A").values.get("b"));
        g = this.parse("@A(1) main:x;");
        Assert.assertEquals((int)1, (int)g.findProduction((String)"main").getChoices().get((int)0).findAnnotation((String)"A").values.keySet().size());
    }

    @Test
    public void testParserFST() throws ParseException, FileNotFoundException {
        SlimJJParser parser = new SlimJJParser(new FileInputStream("test/fj_fst.gcide"));
        NGrammar grammar = parser.Grammar();
    }

    private NGrammar parse(String t) throws ParseException, FileNotFoundException {
        SlimJJParser parser = new SlimJJParser(new ByteArrayInputStream(("GRAMMARSTART " + t).getBytes()));
        return parser.Grammar();
    }
}

