/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.cide.fstgen;

import cide.astgen.nparser.ast.NAbstractValue;
import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.ast.NNonTerminal;
import cide.astgen.nparser.ast.NProduction;
import cide.astgen.nparser.ast.NTextOnly;
import cide.astgen.nparser.ast.NValue;
import cide.astgen.nparser.visitor.NVisitor;
import java.io.PrintStream;

public class JavaCCPrintVisitor
extends NVisitor {
    private PrintStream out;
    boolean inTerminalChoice = false;
    private String fstNamePattern;
    private String fstExportNamePattern;

    public JavaCCPrintVisitor(PrintStream out) {
        this.out = out;
    }

    public boolean visit(NProduction p) {
        this.out.println("FSTInfo " + p.getName() + "(boolean inTerminal) : { Token first=null,t;FSTInfo n; ");
        this.printParameter(p);
        this.out.print("} { {first=getToken(1); productionStart(inTerminal); } (");
        return super.visit(p);
    }

    private void printParameter(NProduction p) {
    }

    public void postVisit(NProduction g) {
        this.out.println();
        this.out.println(" )  }");
        this.out.println();
        super.postVisit(g);
    }

    public boolean visit(NChoice c) {
        this.inTerminalChoice = c.findAnnotation("FSTNonTerminal") == null;
        this.fstNamePattern = "\"-\"";
        if (c.findAnnotation("FSTNonTerminal") != null && c.findAnnotation((String)"FSTNonTerminal").values.get("name") != null) {
            this.fstNamePattern = c.findAnnotation((String)"FSTNonTerminal").values.get("name");
        }
        if (c.findAnnotation("FSTTerminal") != null && c.findAnnotation((String)"FSTTerminal").values.get("name") != null) {
            this.fstNamePattern = c.findAnnotation((String)"FSTTerminal").values.get("name");
        }
        this.fstExportNamePattern = this.fstNamePattern;
        if (c.findAnnotation("FSTExportName") != null && c.findAnnotation((String)"FSTExportName").values.get("value") != null) {
            this.fstExportNamePattern = c.findAnnotation((String)"FSTExportName").values.get("value");
        }
        if (c.findAnnotation("FSTExportName") != null && c.findAnnotation((String)"FSTExportName").values.get("name") != null) {
            this.fstExportNamePattern = c.findAnnotation((String)"FSTExportName").values.get("name");
        }
        this.out.print("\n\t");
        return super.visit(c);
    }

    public void postVisit(NChoice c) {
        if (this.inTerminalChoice) {
            String mergingMechanism;
            String compositionMechanism = c.findAnnotationValue("FSTTerminal", "compose");
            if (compositionMechanism == null) {
                compositionMechanism = "\"Replacement\"";
            }
            if ((mergingMechanism = c.findAnnotationValue("FSTTerminal", "merge")) == null) {
                mergingMechanism = "\"Default\"";
            }
            this.out.println("{return productionEndTerminal(" + JavaCCPrintVisitor.getFSTType(c) + "," + this.fstNamePattern + "," + this.fstExportNamePattern + "," + compositionMechanism + "," + mergingMechanism + ",first,token);}");
        } else {
            this.out.println("{return productionEndNonTerminal(" + JavaCCPrintVisitor.getFSTType(c) + "," + this.fstNamePattern + "," + this.fstExportNamePattern + ");}");
        }
        if (c.getParent().getChoices().indexOf(c) != c.getParent().getChoices().size() - 1) {
            this.out.print(" |");
        }
        super.postVisit(c);
    }

    public static String getFSTType(NChoice c) {
        String a = c.findAnnotationValue("FSTNonTerminal", "type");
        if (a != null) {
            return a;
        }
        a = c.findAnnotationValue("FSTTerminal", "type");
        if (a != null) {
            return a;
        }
        return String.valueOf('\"') + c.genClassname() + '\"';
    }

    public boolean visit(NNonTerminal t) {
        this.visitA(t);
        return super.visit(t);
    }

    public boolean visit(NTextOnly t) {
        this.visitA(t);
        return super.visit(t);
    }

    public boolean visit(NGrammar t) {
        this.out.println(t.getIntroduction());
        return true;
    }

    public boolean visit(NValue t) {
        this.visitA(t);
        return super.visit(t);
    }

    public boolean visitA(NAbstractValue t) {
        for (String x : t.outerPreTokens) {
            this.printToken(x, true);
        }
        switch (t.type) {
            case ZEROORONE: {
                this.out.print("[");
                this.printInner(t);
                this.out.print("]");
                break;
            }
            case ZEROORMORE: {
                this.out.print("(");
                this.printInner(t);
                this.out.print(")*");
                break;
            }
            case ONEORMORE: {
                this.out.print("(");
                this.printInner(t);
                this.out.print(")+");
                break;
            }
            case ONE: 
            case OPTIONALWITHDEFAULT: {
                this.printInner(t);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.out.print(" ");
        for (String x : t.outerPostTokens) {
            this.printToken(x, true);
        }
        return true;
    }

    private void printToken(String x, boolean spaceAfter) {
        if (x.charAt(0) == '\"') {
            if (x.substring(0, 3).equals("\"!<")) {
                this.out.print(String.valueOf(spaceAfter ? "" : " ") + x.substring(2, x.indexOf(62) + 1) + (spaceAfter ? " " : ""));
            } else {
                this.out.print(String.valueOf(spaceAfter ? "" : " ") + x + (spaceAfter ? " " : ""));
            }
        }
        if (x.charAt(0) == 'L') {
            this.out.print("LOOKAHEAD(" + this.removeQuotes(x.substring(1)) + ") ");
        }
        if (x.charAt(0) == 'J') {
            this.out.print(" {" + this.removeQuotes(x.substring(1)) + "} ");
        }
    }

    private String removeQuotes(String name) {
        if (name.length() >= 2 && name.charAt(0) == '\"') {
            return name.substring(1, name.length() - 1).replace("\\", "");
        }
        return name;
    }

    private void printInner(NAbstractValue t) {
        for (String x : t.innerPreTokens) {
            this.printToken(x, true);
        }
        if (t instanceof NNonTerminal) {
            this.out.print("n=" + t.getName() + "(" + (this.inTerminalChoice ? "true" : "inTerminal") + ")");
            if (this.keepName(t)) {
                this.out.print("{ replaceName(\"" + t.getName() + "\", n);}");
            }
            this.out.print("{ replaceName(n);}");
        }
        if (t instanceof NValue) {
            boolean keepName = this.keepName(t);
            if (keepName) {
                this.out.print("t=");
            }
            this.out.print(t.getName());
            if (keepName) {
                this.out.print("{ replaceName(new FSTInfo(\"" + t.getName() + "\",t.image));}");
            }
        }
        if (t instanceof NTextOnly) {
            NAbstractValue.Type cfr_ignored_0 = t.type;
        }
        if (!t.isListElement() && t.type != NAbstractValue.Type.ONEORMORE) {
            NAbstractValue.Type cfr_ignored_1 = t.type;
        }
        for (String x : t.innerPostTokens) {
            this.printToken(x, false);
        }
    }

    private boolean keepName(NAbstractValue t) {
        boolean keepName = this.fstNamePattern.contains("{" + t.getName() + "}");
        keepName |= this.fstExportNamePattern.contains("{" + t.getName() + "}");
        return keepName |= JavaCCPrintVisitor.getFSTType(t.getParent()).contains("{" + t.getName() + "}");
    }
}

