/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.cide.fstgen;

import cide.astgen.nparser.ast.NAbstractValue;
import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.ast.NNonTerminal;
import cide.astgen.nparser.visitor.NCreateFileVisitor;
import de.ovgu.cide.fstgen.JavaCCPrintVisitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashMap;

public class CreatePrettyPrinterVisitor
extends NCreateFileVisitor {
    private boolean autoSpacingPrettyPrinter;
    private final HashMap<String, String> subtypeRelation = new HashMap();

    public CreatePrettyPrinterVisitor(File targetDir, String targetPackage, boolean autoSpacingPrettyPrinter) throws FileNotFoundException {
        super(targetDir, "SimplePrintVisitor.java", targetPackage);
        this.autoSpacingPrettyPrinter = autoSpacingPrettyPrinter;
    }

    public CreatePrettyPrinterVisitor(PrintStream stream, String targetPackage, boolean autoSpacingPrettyPrinter) {
        super(stream, targetPackage);
        this.autoSpacingPrettyPrinter = autoSpacingPrettyPrinter;
    }

    public boolean visit(NGrammar g) {
        this.printHead();
        return super.visit(g);
    }

    public void postVisit(NGrammar g) {
        this.printTail();
        super.postVisit(g);
    }

    public boolean visit(NChoice c) {
        if (!JavaCCPrintVisitor.getFSTType(c).equals(String.valueOf('\"') + c.getParent().getName() + '\"')) {
            this.subtypeRelation.put(JavaCCPrintVisitor.getFSTType(c), c.getParent().getName());
        }
        if (!this.isNonTerminal(c)) {
            return false;
        }
        if (c.units.isEmpty()) {
            return false;
        }
        this.println("if (nonTerminal.getType().equals(" + JavaCCPrintVisitor.getFSTType(c) + ")) {", 2);
        this.println("printFeatures(nonTerminal,true);", 3);
        if (c.isList()) {
            this.println("Iterator<FSTNode> listElements = getChildren(nonTerminal, \"" + c.getListType() + "\").iterator();", 3);
        }
        for (NAbstractValue unit : c.units) {
            for (String t : unit.outerPreTokens) {
                this.printToken(t, 3);
            }
            if (unit instanceof NNonTerminal) {
                this.visitUnit((NNonTerminal)unit);
            }
            for (String t : unit.outerPostTokens) {
                this.printToken(t, 3);
            }
        }
        this.println("printFeatures(nonTerminal,false);", 3);
        this.println("return false;", 3);
        this.println("}", 2);
        return false;
    }

    private boolean isNonTerminal(NChoice c) {
        return c.findAnnotation("FSTNonTerminal") != null;
    }

    private void printToken(String token, int indent) {
        if (token.length() > 3 && token.subSequence(0, 3).equals("\"!<")) {
            token = String.valueOf('\"') + token.substring(token.indexOf(62) + 1);
        }
        if (token.charAt(0) == '\"') {
            this.println("printToken(\"" + token.substring(1, token.length() - 1) + "\");", indent);
        }
        if (token.charAt(0) == '@') {
            this.handleLayoutHint(token, indent);
        }
    }

    private void handleLayoutHint(String hint, int indent) {
        if (hint.indexOf(40) > 0) {
            return;
        }
        if (hint.indexOf(43) > 0) {
            this.println("hintIncIndent();", indent);
        }
        if (hint.indexOf(45) > 0) {
            this.println("hintDecIndent();", indent);
        }
        if (hint.indexOf(110) > 0) {
            this.println("hintNewLine();", indent);
        }
        if (hint.indexOf(115) > 0) {
            this.println("hintSingleSpace();", indent);
        }
    }

    void visitUnit(NNonTerminal unit) {
        if (unit.isListElement()) {
            String command = !NAbstractValue.isMultiType(unit.type) ? "if" : "while";
            this.println(String.valueOf(command) + " (listElements.hasNext()) {", 3);
            for (String t : unit.innerPreTokens) {
                this.printToken(t, 4);
            }
            this.println("listElements.next().accept(this);", 4);
            for (String t : unit.innerPostTokens) {
                this.printToken(t, 4);
            }
            this.println("}", 3);
        } else if (!NAbstractValue.isMultiType(unit.type)) {
            this.println("{", 3);
            this.println("FSTNode v=getChild(nonTerminal, \"" + unit.getName() + "\");", 4);
            this.println("if (v!=null) {", 4);
            for (String t : unit.innerPreTokens) {
                this.printToken(t, 5);
            }
            this.println("v.accept(this);", 5);
            for (String t : unit.innerPostTokens) {
                this.printToken(t, 5);
            }
            this.println("}", 4);
            this.println("}", 3);
        } else {
            this.println("for (FSTNode v : getChildren(nonTerminal,\"" + unit.getName() + "\")) {", 3);
            for (String t : unit.innerPreTokens) {
                this.printToken(t, 4);
            }
            this.println("v.accept(this);", 4);
            for (String t : unit.innerPostTokens) {
                this.printToken(t, 4);
            }
            this.println("}", 3);
        }
    }

    private void printHead() {
        if (this.targetPackage != null && this.targetPackage.length() > 0) {
            this.println("package " + this.targetPackage + ";\n", 0);
        }
        this.println("import java.util.*;", 0);
        this.println("import cide.gast.*;\n", 0);
        this.println("import java.io.PrintStream;\n", 0);
        this.println("import cide.languages.*;\n", 0);
        this.println("import de.ovgu.cide.fstgen.ast.*;\n", 0);
        this.println("public class SimplePrintVisitor extends AbstractFSTPrintVisitor  {", 0);
        this.println("public SimplePrintVisitor(PrintStream out) {", 1);
        this.println("super(out); generateSpaces=" + (this.autoSpacingPrettyPrinter ? "true" : "false") + ";", 2);
        this.println("}", 1);
        this.println("public SimplePrintVisitor() {", 1);
        this.println("super(); generateSpaces=" + (this.autoSpacingPrettyPrinter ? "true" : "false") + ";", 2);
        this.println("}", 1);
        this.println("public boolean visit(FSTNonTerminal nonTerminal) {", 1);
    }

    private void printTail() {
        this.println("throw new RuntimeException(\"Unknown Non Terminal in FST \"+nonTerminal);", 2);
        this.println("}", 1);
        this.println("protected boolean isSubtype(String type, String expectedType) {", 1);
        this.println("if (type.equals(expectedType)) return true;", 2);
        for (String key : this.subtypeRelation.keySet()) {
            this.println("if (type.equals(" + key + ") && expectedType.equals(\"" + this.subtypeRelation.get(key) + "\")) return true;", 2);
        }
        this.println("return false;", 2);
        this.println("}", 1);
        this.println("}", 0);
    }
}

