/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.cide.fstgen;

import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.parser.ParseException;
import de.ovgu.cide.fstgen.AbstractNParser;
import de.ovgu.cide.fstgen.CreateFSTVisitor;
import de.ovgu.cide.fstgen.ast.FSTNodeType;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFSTVisitorTest
extends AbstractNParser {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testCheckWellformedAnnotationsFJ() throws Exception {
        NGrammar grammar = this.parseFile("test/fj_fst.gcide");
        CreateFSTVisitor v = new CreateFSTVisitor();
        grammar.accept(v);
        Assert.assertTrue((String)v.getWellformedErrorMsg(), (boolean)v.hasWellformedFSTAnnotations());
    }

    @Test
    @Ignore
    public void testCheckWellformedAnnotationsJava() throws Exception {
        NGrammar grammar = this.parseFile("test/java15_fst.gcide");
        CreateFSTVisitor v = new CreateFSTVisitor();
        grammar.accept(v);
        Assert.assertTrue((String)v.getWellformedErrorMsg(), (boolean)v.hasWellformedFSTAnnotations());
    }

    @Test
    public void checkUnannotatedGrammar() throws ParseException {
        this.checkWellformed("m:x;x:<i>;");
    }

    @Test
    public void checkTerminalAndNonTerminal() throws ParseException {
        this.checkIllformed("@FSTNonTerminal(name=\"abc\") @FSTTerminal m:x;x:<i>;");
    }

    @Test
    public void checkNonTerminalFromTerminal() throws ParseException {
        this.checkIllformed("@FSTTerminal m:x; @FSTNonTerminal(name=\"abc\") x:<i>;");
    }

    @Test
    public void checkTerminalFromNonTerminal() throws ParseException {
        this.checkWellformed("@FSTNonTerminal(name=\"abc\") m:x; @FSTTerminal x:<i>;");
    }

    @Test
    public void checkNonTerminalName() throws ParseException {
        this.checkWellformed("@FSTNonTerminal(name=\"abc\") m:x; @FSTTerminal x:<i>;");
        this.checkIllformed("@FSTNonTerminal m:x; @FSTTerminal x:<i>;");
    }

    @Test
    public void testTypeCollector() throws ParseException {
        Set<FSTNodeType> types = this.getNodeTypes("m:x; x:<i>;");
        Assert.assertEquals((int)1, (int)types.size());
        types = this.getNodeTypes("@FSTNonTerminal(name=\"abc\") m:x; @FSTTerminal x:<i>;");
        Assert.assertEquals((int)2, (int)types.size());
        int found = 0;
        for (FSTNodeType t : types) {
            if ("m".equals(t.getName())) {
                Assert.assertFalse((String)"m is not terminal", (boolean)t.isTerminal());
                ++found;
            }
            if (!"x".equals(t.getName())) continue;
            Assert.assertTrue((String)"x is terminal", (boolean)t.isTerminal());
            ++found;
        }
        Assert.assertTrue((found == 2 ? 1 : 0) != 0);
        this.printTypes(types);
    }

    @Test
    public void testTypeCollectorFJ() throws Exception {
        NGrammar grammar = this.parseFile("test/fj_fst.gcide");
        CreateFSTVisitor v = new CreateFSTVisitor();
        grammar.accept(v);
        Set<FSTNodeType> types = v.getFSTNodeTypes();
        this.printTypes(types);
        int found = 0;
        for (FSTNodeType t : types) {
            if ("TypeDeclaration".equals(t.getName())) {
                Assert.assertFalse((String)"m is not terminal", (boolean)t.isTerminal());
                ++found;
            }
            if (!"ClassConstructor".equals(t.getName()) && !"MethodDeclaration".equals(t.getName()) && !"VarDeclaration".equals(t.getName()) && !"ExtendedType1".equals(t.getName()) && !"ExtendedType2".equals(t.getName())) continue;
            Assert.assertTrue((String)"x is terminal", (boolean)t.isTerminal());
            ++found;
        }
        Assert.assertEquals((int)6, (int)found);
    }

    @Test
    @Ignore
    public void testTypeCollectorJava() throws Exception {
        NGrammar grammar = this.parseFile("test/java15_fst.gcide");
        CreateFSTVisitor v = new CreateFSTVisitor();
        grammar.accept(v);
        Set<FSTNodeType> types = v.getFSTNodeTypes();
        this.printTypes(types);
        Assert.assertEquals((int)5, (int)types.size());
    }

    private void printTypes(Set<FSTNodeType> types) {
    }

    private Set<FSTNodeType> getNodeTypes(String grammarStr) throws ParseException {
        NGrammar grammar = this.parse(grammarStr);
        CreateFSTVisitor v = new CreateFSTVisitor();
        grammar.accept(v);
        Assert.assertTrue((String)("Not considered wellformed: " + grammarStr + " Reason: " + v.getWellformedErrorMsg()), (boolean)v.hasWellformedFSTAnnotations());
        return v.getFSTNodeTypes();
    }

    private void checkWellformed(String grammarStr) throws ParseException {
        this.getNodeTypes(grammarStr);
    }

    private void checkIllformed(String grammarStr) throws ParseException {
        NGrammar grammar = this.parse(grammarStr);
        CreateFSTVisitor v = new CreateFSTVisitor();
        grammar.accept(v);
        Assert.assertTrue((String)("Considered wellformed: " + grammarStr), (!v.hasWellformedFSTAnnotations() ? 1 : 0) != 0);
    }
}

