/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.cide.fstgen;

import cide.astgen.nparser.ast.NAbstractValue;
import cide.astgen.nparser.ast.NAnnotation;
import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.ast.NNonTerminal;
import cide.astgen.nparser.ast.NProduction;
import cide.astgen.nparser.ast.NValue;
import cide.astgen.nparser.visitor.NVisitor;
import de.ovgu.cide.fstgen.ast.FSTNodeType;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFSTVisitor
extends NVisitor {
    private boolean isWellformed = true;
    private String errorMsg = "";
    private Set<FSTNodeType> fstNodeTypes = new HashSet<FSTNodeType>();
    private Set<NChoice> generatedTypes = new HashSet<NChoice>();

    public String printDebug() {
        return "";
    }

    @Override
    public boolean visit(NChoice choice) {
        NAnnotation nonTerminalAnnotation = choice.findAnnotation("FSTNonTerminal");
        NAnnotation terminalAnnotation = choice.findAnnotation("FSTTerminal");
        NGrammar grammar = choice.getParent().getGrammar();
        this.checkWellformedness(choice, nonTerminalAnnotation, terminalAnnotation, grammar);
        this.genType(choice, nonTerminalAnnotation, terminalAnnotation, grammar);
        return super.visit(choice);
    }

    private void genType(NChoice choice, NAnnotation nonTerminalAnnotation, NAnnotation terminalAnnotation, NGrammar grammar) {
        if (nonTerminalAnnotation != null) {
            this.fstNodeTypes.add(new FSTNodeType(choice.genClassname(), false));
            this.generatedTypes.add(choice);
            for (NAbstractValue unit : choice.getUnits()) {
                NProduction referencedProduction;
                if (!(unit instanceof NNonTerminal) || (referencedProduction = grammar.findProduction(((NNonTerminal)unit).getName())) == null) continue;
                for (NChoice targetChoice : referencedProduction.getChoices()) {
                    if (targetChoice.findAnnotation("FSTNonTerminal") != null) continue;
                    this.makeNonTerminalType(targetChoice);
                }
            }
        }
        if (nonTerminalAnnotation == null && choice.getParent().isFirstProduction()) {
            this.makeNonTerminalType(choice);
        }
    }

    private void makeNonTerminalType(NChoice choice) {
        if (!this.generatedTypes.contains(choice)) {
            this.generatedTypes.add(choice);
            this.fstNodeTypes.add(new FSTNodeType(choice.genClassname(), true));
        }
    }

    private void checkWellformedness(NChoice p, NAnnotation nonTerminalAnnotation, NAnnotation terminalAnnotation, NGrammar grammar) {
        if (nonTerminalAnnotation != null && terminalAnnotation != null) {
            this.markNotWellformed("Choice " + p.genClassname() + " in production " + p.getParent().getName() + " cannot be a terminal and a non-terminal at the same time.");
        }
        if (nonTerminalAnnotation != null) {
            for (NAbstractValue unit : p.getUnits()) {
                if (!(unit instanceof NValue) || "<EOF>".equals(unit.getName()) || "<NONE>".equals(unit.getName())) continue;
                this.markNotWellformed("Non-terminal choice " + p.genClassname() + " in production " + p.getParent().getName() + " must not contain the token reference " + unit.getName());
            }
        }
        if (nonTerminalAnnotation == null) {
            for (NAbstractValue unit : p.getUnits()) {
                NProduction referencedProduction;
                if (!(unit instanceof NNonTerminal) || (referencedProduction = grammar.findProduction(((NNonTerminal)unit).getName())) == null) continue;
                for (NChoice c : referencedProduction.getChoices()) {
                    if (c.findAnnotation("FSTNonTerminal") == null) continue;
                    this.markNotWellformed("Terminal choice " + p.genClassname() + " in production " + p.getParent().getName() + " must not reference non-terminal choice " + c.genClassname() + " in " + referencedProduction.getName());
                }
            }
        }
    }

    private void markNotWellformed(String string) {
        this.isWellformed = false;
        this.errorMsg = String.valueOf(this.errorMsg) + string + "\n";
    }

    public boolean hasWellformedFSTAnnotations() {
        return this.isWellformed;
    }

    public String getWellformedErrorMsg() {
        return this.errorMsg;
    }

    public Set<FSTNodeType> getFSTNodeTypes() {
        return this.fstNodeTypes;
    }
}

