/*
 * Decompiled with CFR 0.152.
 */
package counter;

import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;

public class Counter {
    LinkedList<Entry> data = new LinkedList();

    public void collect(FSTNode node) {
        if (node.getType().equals("ClassDeclaration") || node.getType().equals("MethodDecl") || node.getType().equals("InnerEnumDecl") || node.getType().equals("InnerClassDecl") || node.getType().equals("FieldDecl") || node.getType().equals("ConstructorDecl")) {
            this.collectJava(node);
        } else if (node.getType().equals("Func") || node.getType().equals("StmtYL") || node.getType().equals("StmtTL")) {
            this.collectC(node);
        }
        if (node instanceof FSTNonTerminal) {
            for (FSTNode child : ((FSTNonTerminal)node).getChildren()) {
                this.collect(child);
            }
        }
    }

    private void collectJava(FSTNode node) {
        String name = node.getName();
        String type = node.getType();
        String feature = Counter.getFeatureName(node);
        if (node.getType().equals("InnerClassDecl")) {
            type = "ClassDeclaration";
        }
        if (node.getType().equals("MethodDecl") || node.getType().equals("ConstructorDecl")) {
            name = String.valueOf(name.substring(0, name.indexOf("("))) + "()";
        }
        name = Counter.getQualifiedJavaName(name, node.getParent());
        Entry entry = new Entry(name, type, feature);
        this.data.add(entry);
    }

    private void collectC(FSTNode node) {
        String name = node.getName();
        String type = node.getType();
        String feature = Counter.getFeatureName(node);
        if (node.getType().equals("Func")) {
            name = String.valueOf(name.substring(0, name.indexOf("("))) + "()";
        }
        name = Counter.getQualifiedCName(name, node.getParent());
        Entry entry = new Entry(name, type, feature);
        this.data.add(entry);
    }

    public void writeFile(File file) {
        try {
            file.createNewFile();
            BufferedWriter textFileWriter = new BufferedWriter(new FileWriter(file));
            for (Entry entry : this.data) {
                textFileWriter.write(String.valueOf(entry.toString()) + "\n");
            }
            textFileWriter.flush();
            textFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getQualifiedJavaName(String name, FSTNode node) {
        if (node.getType().equals("Feature")) {
            return name;
        }
        if (node.getType().equals("ClassDeclaration") || node.getType().equals("InnerClassDecl")) {
            name = name.contains(".") ? String.valueOf(node.getName()) + "::" + name : String.valueOf(node.getName()) + "." + name;
        } else if (node.getType().equals("Folder")) {
            name = String.valueOf(node.getName()) + "::" + name;
        }
        return Counter.getQualifiedJavaName(name, node.getParent());
    }

    private static String getQualifiedCName(String name, FSTNode node) {
        if (node.getType().equals("Feature")) {
            return name;
        }
        if (node.getType().equals("H-File") || node.getType().equals("C-File") || node.getType().equals("StructDec")) {
            name = String.valueOf(node.getName()) + "." + name;
        } else if (node.getType().equals("Folder")) {
            name = String.valueOf(node.getName()) + "/" + name;
        }
        return Counter.getQualifiedCName(name, node.getParent());
    }

    private static String getFeatureName(FSTNode node) {
        if (node.getType().equals("Feature")) {
            return node.getName();
        }
        return Counter.getFeatureName(node.getParent());
    }

    private class Entry {
        private String name = "";
        private String type = "";
        private String feature = "";

        public Entry(String n, String t, String f) {
            this.name = n;
            this.type = t;
            this.feature = f;
        }

        public String toString() {
            return "Introduces " + this.feature + " " + this.name + " " + this.type;
        }
    }
}

