/*
 * Decompiled with CFR 0.152.
 */
package composer;

import builder.ArtifactBuilderInterface;
import cide.gparser.ParseException;
import composer.FSTGenProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import modification.ModificationComposition;
import modification.content.UnknownContentTypeParseException;
import modification.content.UnknownFileTypeParseException;
import modification.xmlParser.XmlParser;
import org.xml.sax.SAXException;

public class FileLoader {
    private static final String MODIFICATION_FOLDER_TAG = "_mod";
    private static final String MODIFICATION_CONTROL_FILE_TAG = "mod.xml";
    private LinkedList<ArtifactBuilderInterface> builderList;
    private MyFileFilter fileFilter = new MyFileFilter();
    private DirectoryFileFilter directoryFileFilter = new DirectoryFileFilter();
    private FSTGenProcessor composer;
    private ModificationComposition modcomposition = new ModificationComposition();
    private boolean preprocessFiles = false;

    public boolean isPreprocessFiles() {
        return this.preprocessFiles;
    }

    public void setPreprocessFiles(boolean preprocessFiles) {
        this.preprocessFiles = preprocessFiles;
    }

    public FileLoader(FSTGenProcessor genComposer) {
        this.builderList = new LinkedList();
        this.composer = genComposer;
    }

    public void registerArtifactBuilder(ArtifactBuilderInterface builder) {
        this.builderList.add(builder);
    }

    public void unregisterArtifactBuilder(ArtifactBuilderInterface builder) {
        this.builderList.remove(builder);
    }

    public LinkedList<ArtifactBuilderInterface> getArtifactBuilders() {
        return this.builderList;
    }

    public void loadFiles(String equationFileName, String equationBaseDirectoryName, boolean aheadEquation) throws FileNotFoundException, ParseException {
        this.parseEquationFile(equationFileName, equationBaseDirectoryName, aheadEquation);
    }

    private void parseEquationFile(String equationFileName, String equationBaseDirectoryName, boolean aheadEquation) throws FileNotFoundException, ParseException {
        if (equationFileName == null || equationFileName.length() == 0) {
            throw new FileNotFoundException();
        }
        File equationFile = new File(equationFileName);
        String equationFileContent = "";
        try {
            BufferedReader fileReader = new BufferedReader(new FileReader(equationFile));
            String line = fileReader.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    equationFileContent = String.valueOf(equationFileContent) + line + " ";
                }
                line = fileReader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!equationFileContent.equals("")) {
            String[] features = equationFileContent.split("\\s");
            System.out.println("Found the following features:");
            String[] stringArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                System.out.println(s);
                ++n2;
            }
            Iterator iterator = this.builderList.iterator();
            if (!equationBaseDirectoryName.trim().endsWith("" + File.separatorChar)) {
                equationBaseDirectoryName = String.valueOf(equationBaseDirectoryName.trim()) + File.separatorChar;
            }
            while (iterator.hasNext()) {
                ((ArtifactBuilderInterface)iterator.next()).setBaseDirectoryName(this.getDirectoryName(new File(equationBaseDirectoryName)));
            }
            int i = 0;
            while (i < features.length) {
                if (features[i].trim().length() > 0) {
                    File feature = new File(String.valueOf(equationBaseDirectoryName) + features[i]);
                    this.parseDirectory(feature, !aheadEquation);
                }
                ++i;
            }
        }
    }

    private void parseDirectory(File directory, boolean recursive) throws FileNotFoundException, ParseException {
        if (directory.getName().equals(MODIFICATION_FOLDER_TAG)) {
            try {
                XmlParser xmlpars = new XmlParser(new File(String.valueOf(directory.getPath()) + File.separator + MODIFICATION_CONTROL_FILE_TAG));
                this.modcomposition.addAll(xmlpars.parse());
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnknownFileTypeParseException e) {
                e.printStackTrace();
            }
            catch (UnknownContentTypeParseException e) {
                e.printStackTrace();
            }
        } else if (recursive) {
            File[] directories;
            File[] files = directory.listFiles(this.fileFilter);
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    for (ArtifactBuilderInterface builder : this.builderList) {
                        if (!builder.acceptFile(files[i])) continue;
                        try {
                            if (this.isPreprocessFiles()) {
                                builder.setPreprocessNode(true);
                            }
                            builder.processFile(files[i]);
                        }
                        catch (ParseException e) {
                            this.composer.getErrorFiles().add(files[i]);
                            this.composer.fireParseErrorOccured(e);
                        }
                    }
                    ++i;
                }
            }
            if ((directories = directory.listFiles(this.directoryFileFilter)) != null) {
                int i = 0;
                while (i < directories.length) {
                    this.parseDirectory(directories[i], recursive);
                    ++i;
                }
            }
        } else {
            File[] files = directory.listFiles(this.fileFilter);
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    for (ArtifactBuilderInterface builder : this.builderList) {
                        if (!builder.acceptFile(files[i])) continue;
                        try {
                            builder.processFile(files[i]);
                        }
                        catch (ParseException e) {
                            this.composer.getErrorFiles().add(files[i]);
                            this.composer.fireParseErrorOccured(e);
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            } else {
                System.out.println("Input directory does not contain any parsable files: " + directory.getPath());
            }
        }
    }

    private String getDirectoryName(File file) {
        String result = "";
        result = file.isDirectory() ? file.getPath() : file.getParentFile().getPath();
        return result;
    }

    public ModificationComposition getModifications() {
        return this.modcomposition;
    }

    private class DirectoryFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            if (pathname.isFile()) {
                return false;
            }
            return pathname.isDirectory();
        }
    }

    private class MyFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    }
}

