/*
 * Decompiled with CFR 0.152.
 */
package composer;

import builder.ArtifactBuilderInterface;
import builder.capprox.CApproxBuilder;
import builder.java.JavaBuilder;
import composer.CmdLineInterpreter;
import composer.FSTGenProcessor;
import composer.rules.CSharpMethodOverriding;
import composer.rules.CompositionError;
import composer.rules.ConstructorConcatenation;
import composer.rules.ExpansionOverriding;
import composer.rules.FieldOverriding;
import composer.rules.ImplementsListMerging;
import composer.rules.JavaMethodOverriding;
import composer.rules.ModifierListSpecialization;
import composer.rules.StringConcatenation;
import counter.Counter;
import de.ovgu.cide.fstgen.ast.AbstractFSTParser;
import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import de.ovgu.cide.fstgen.ast.FSTTerminal;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import modification.content.InvalidFSTTraversalException;
import modification.traversalLanguageParser.ParseException;
import printer.PrintVisitorException;

public class FSTGenComposer
extends FSTGenProcessor {
    private CmdLineInterpreter cmd = new CmdLineInterpreter();

    public void run(String[] args) {
        this.cmd.parseCmdLineArguments(args);
        try {
            try {
                this.fileLoader.loadFiles(this.cmd.equationFileName, this.cmd.equationBaseDirectoryName, this.cmd.isAheadEquationFile);
            }
            catch (cide.gparser.ParseException e1) {
                System.out.println("error");
                this.fireParseErrorOccured(e1);
                e1.printStackTrace();
            }
            String outputDir = this.cmd.equationBaseDirectoryName;
            if (this.cmd.outputDirectoryName != null) {
                outputDir = this.cmd.outputDirectoryName;
            }
            this.featureVisitor.setWorkingDir(outputDir);
            this.featureVisitor.setExpressionName(this.cmd.equationFileName);
            for (ArtifactBuilderInterface builder : this.getArtifactBuilders()) {
                LinkedList<FSTNonTerminal> features = builder.getFeatures();
                if (this.cmd.isCount && (builder instanceof JavaBuilder || builder instanceof CApproxBuilder)) {
                    Counter counter = new Counter();
                    for (FSTNonTerminal feature : features) {
                        counter.collect(feature);
                    }
                    if (features.size() > 0) {
                        counter.writeFile(new File(String.valueOf(this.cmd.equationFileName) + ".rsf"));
                    }
                }
                FSTNode composition = FSTGenComposer.compose(features);
                try {
                    this.featureVisitor.visit((FSTNonTerminal)composition);
                }
                catch (PrintVisitorException e) {
                    e.printStackTrace();
                }
            }
            this.setFstnodes(AbstractFSTParser.fstnodes);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void modify(FSTNode composition) {
        if (composition != null) {
            try {
                this.fileLoader.getModifications().apply(composition);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (cide.gparser.ParseException e) {
                e.printStackTrace();
            }
            catch (InvalidFSTTraversalException e) {
                e.printStackTrace();
            }
            System.out.println(composition);
        }
    }

    public static void main(String[] args) {
        FSTGenComposer composer = new FSTGenComposer();
        composer.run(args);
    }

    private static FSTNode compose(List<FSTNonTerminal> tl) {
        FSTNode composed = null;
        for (FSTNode fSTNode : tl) {
            composed = composed != null ? FSTGenComposer.compose(fSTNode, composed) : fSTNode;
        }
        return composed;
    }

    public static FSTNode compose(FSTNode nodeA, FSTNode nodeB) {
        return FSTGenComposer.compose(nodeA, nodeB, null);
    }

    public static FSTNode compose(FSTNode nodeA, FSTNode nodeB, FSTNode compParent) {
        if (nodeA.compatibleWith(nodeB)) {
            FSTNode compNode = nodeA.getShallowClone();
            compNode.setParent(compParent);
            if (nodeA instanceof FSTNonTerminal && nodeB instanceof FSTNonTerminal) {
                FSTNonTerminal nonterminalA = (FSTNonTerminal)nodeA;
                FSTNonTerminal nonterminalB = (FSTNonTerminal)nodeB;
                FSTNonTerminal nonterminalComp = (FSTNonTerminal)compNode;
                for (FSTNode childB : nonterminalB.getChildren()) {
                    FSTNode childA = nonterminalA.getCompatibleChild(childB);
                    if (childA == null) {
                        nonterminalComp.addChild(childB.getDeepClone());
                        continue;
                    }
                    nonterminalComp.addChild(FSTGenComposer.compose(childA, childB, nonterminalComp));
                }
                for (FSTNode childA : nonterminalA.getChildren()) {
                    FSTNode childB = nonterminalB.getCompatibleChild(childA);
                    if (childB != null) continue;
                    nonterminalComp.addChild(childA.getDeepClone());
                }
                return nonterminalComp;
            }
            if (nodeA instanceof FSTTerminal && nodeB instanceof FSTTerminal && compParent instanceof FSTNonTerminal) {
                FSTTerminal terminalA = (FSTTerminal)nodeA;
                FSTTerminal terminalB = (FSTTerminal)nodeB;
                FSTTerminal terminalComp = (FSTTerminal)compNode;
                FSTNonTerminal nonterminalParent = (FSTNonTerminal)compParent;
                if (!terminalA.getCompositionMechanism().equals("Replacement")) {
                    if (terminalA.getCompositionMechanism().equals("StringConcatenation")) {
                        StringConcatenation.compose(terminalA, terminalB, terminalComp, nonterminalParent);
                    } else if (terminalA.getCompositionMechanism().equals("ImplementsListMerging")) {
                        ImplementsListMerging.compose(terminalA, terminalB, terminalComp, nonterminalParent);
                    } else if (terminalA.getCompositionMechanism().equals("JavaMethodOverriding")) {
                        JavaMethodOverriding.compose(terminalA, terminalB, terminalComp, nonterminalParent);
                    } else if (terminalA.getCompositionMechanism().equals("CSharpMethodOverriding")) {
                        CSharpMethodOverriding.compose(terminalA, terminalB, terminalComp, nonterminalParent);
                    } else if (terminalA.getCompositionMechanism().equals("ConstructorConcatenation")) {
                        ConstructorConcatenation.compose(terminalA, terminalB, terminalComp, nonterminalParent);
                    } else if (terminalA.getCompositionMechanism().equals("ModifierListSpecialization")) {
                        ModifierListSpecialization.compose(terminalA, terminalB, terminalComp, nonterminalParent);
                    } else if (terminalA.getCompositionMechanism().equals("FieldOverriding")) {
                        FieldOverriding.compose(terminalA, terminalB, terminalComp, nonterminalParent);
                    } else if (terminalA.getCompositionMechanism().equals("ExpansionOverriding")) {
                        ExpansionOverriding.compose(terminalA, terminalB, terminalComp, nonterminalParent);
                    } else if (terminalA.getCompositionMechanism().equals("CompositionError")) {
                        CompositionError.compose(terminalA, terminalB, terminalComp, nonterminalParent);
                    } else {
                        System.err.println("Error: don't know how to compose terminals: " + terminalB.toString() + " replaces " + terminalA.toString());
                    }
                }
                return terminalComp;
            }
            return null;
        }
        return null;
    }
}

