/*
 * Decompiled with CFR 0.152.
 */
package composer;

import java.io.File;

public class CmdLineInterpreter {
    public static final String INPUT_OPTION_EQUATIONFILE = "--expression";
    public static final String INPUT_OPTION_AHEAD_EQUATION_FILE = "--ahead";
    public static final String INPUT_OPTION_BASE_DIRECTORY = "--base-directory";
    public static final String INPUT_OPTION_SHOW_GUI = "--gui";
    public static final String INPUT_OPTION_SHOW_XML = "--xml";
    public static final String INPUT_OPTION_SHOW_SUM = "--sum";
    public static final String INPUT_OPTION_SHOW_FST = "--fst";
    public static final String INPUT_OPTION_FILE_OUTPUT = "--write";
    public static final String INPUT_OPTION_OUTPUT_DIRECTORY = "--output-directory";
    public static final String INPUT_OPTION_RESOLVE_REFERENCES = "--resolve-references";
    public static final String INPUT_OPTION_HELP = "--help";
    public static final String INPUT_OPTION_COUNT = "--count";
    public boolean isCount = false;
    public boolean isAheadEquationFile;
    public String equationFileName;
    public String equationBaseDirectoryName;
    public String outputDirectoryName = null;
    public boolean isBaseDirectoryName = false;
    public boolean showXML = false;
    public boolean showFST = false;
    public boolean showSum = false;
    public boolean showGui = false;
    public boolean fileOutput = false;

    public void parseCmdLineArguments(String[] args) {
        boolean errorOccured = false;
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals(INPUT_OPTION_EQUATIONFILE)) {
                    if (++i < args.length) {
                        this.equationFileName = args[i];
                        if (!this.isBaseDirectoryName) {
                            this.equationBaseDirectoryName = String.valueOf(CmdLineInterpreter.getDirectoryName(new File(this.equationFileName))) + File.separator;
                        }
                        this.equationFileName = this.equationFileName.replace("\\", File.separator);
                        this.equationFileName = this.equationFileName.replace("/", File.separator);
                    } else {
                        System.out.println("Error occured option: --expression");
                        errorOccured = true;
                    }
                } else if (args[i].equals(INPUT_OPTION_BASE_DIRECTORY)) {
                    if (++i < args.length) {
                        this.equationBaseDirectoryName = args[i];
                        this.equationBaseDirectoryName = this.equationBaseDirectoryName.replace("\\", File.separator);
                        this.equationBaseDirectoryName = this.equationBaseDirectoryName.replace("/", File.separator);
                        this.isBaseDirectoryName = true;
                    } else {
                        System.out.println("Error occured option: --base-directory");
                        errorOccured = true;
                    }
                } else if (args[i].equals(INPUT_OPTION_OUTPUT_DIRECTORY)) {
                    if (++i < args.length) {
                        this.outputDirectoryName = args[i];
                    } else {
                        System.out.println("Error occured option: --output-directory");
                        errorOccured = true;
                    }
                } else if (args[i].equals(INPUT_OPTION_COUNT)) {
                    this.isCount = true;
                } else if (args[i].equals(INPUT_OPTION_FILE_OUTPUT)) {
                    this.fileOutput = true;
                } else if (args[i].equals(INPUT_OPTION_SHOW_GUI)) {
                    this.showGui = true;
                } else if (args[i].equals(INPUT_OPTION_SHOW_XML)) {
                    this.showXML = true;
                } else if (args[i].equals(INPUT_OPTION_SHOW_FST)) {
                    this.showFST = true;
                } else if (args[i].equals(INPUT_OPTION_SHOW_SUM)) {
                    this.showSum = true;
                } else if (args[i].equals(INPUT_OPTION_AHEAD_EQUATION_FILE)) {
                    this.isAheadEquationFile = true;
                } else if (args[i].equals(INPUT_OPTION_RESOLVE_REFERENCES)) {
                    System.out.println("The option '--resolve-references' is obsolete.");
                } else if (args[i].equals(INPUT_OPTION_HELP)) {
                    CmdLineInterpreter.printHelp(false);
                } else {
                    errorOccured = true;
                }
                ++i;
            }
        } else {
            errorOccured = true;
        }
        if (errorOccured) {
            CmdLineInterpreter.printHelp(errorOccured);
        }
    }

    private static void printHelp(boolean errorOccured) {
        if (errorOccured) {
            System.out.println("Incorrect command line parameters!");
        }
        System.out.println("Use `java -jar FeatureHouse.jar --expression <file name> [--base-directory <directory name>]'");
        System.out.println("The option `--expression' defines the name of the file that lists the input features/components.");
        System.out.println("The option `--base-directory' defines the working directory, which is the search path for the input features/components.");
    }

    private static String getDirectoryName(File file) {
        String result = "";
        result = file.isDirectory() ? file.getPath() : file.getAbsoluteFile().getParentFile().getPath();
        return result;
    }
}

