/*
 * Decompiled with CFR 0.152.
 */
package cide.greferences;

import cide.features.IASTColorProvider;
import cide.gast.ASTNode;
import cide.greferences.AValidationRule;
import cide.greferences.IReference;
import cide.greferences.IReferenceType;
import cide.greferences.IValidationErrorCallback;
import java.util.HashMap;
import java.util.Set;

public abstract class ASimpleSubsetValidationRule
extends AValidationRule {
    private boolean targetIsSubset;
    private IReferenceType type;

    protected ASimpleSubsetValidationRule(IReferenceType type, boolean targetIsSubset) {
        this.type = type;
        this.targetIsSubset = targetIsSubset;
    }

    @Override
    public IReferenceType[] getRequiredReferences() {
        return new IReferenceType[]{this.type};
    }

    @Override
    public void validate(IASTColorProvider colorProvider, HashMap<IReferenceType, Set<IReference>> allReferences, IValidationErrorCallback errorCallback) {
        Set<IReference> references = allReferences.get(this.type);
        for (IReference reference : references) {
            ASTNode source = reference.getSource();
            ASTNode target = reference.getTarget();
            boolean result = this.targetIsSubset ? super.isColorSubset(colorProvider, target, source) : super.isColorSubset(colorProvider, source, target);
            if (result) continue;
            errorCallback.validationError(this.targetIsSubset ? source : target, this);
        }
    }
}

