/*
 * Decompiled with CFR 0.152.
 */
package cide.gast;

import cide.gast.ASTNode;
import cide.gast.Property;
import java.util.ArrayList;
import java.util.List;

public class PropertyZeroOrMore<T extends ASTNode>
extends Property {
    protected final ArrayList<T> valueList;
    protected final List<T> indexList = new ArrayList<T>();

    public PropertyZeroOrMore(String name, ArrayList<T> value) {
        this(name, value, Property.PropertyType.ZEROORMORE);
    }

    protected PropertyZeroOrMore(String name, ArrayList<T> value, Property.PropertyType type) {
        super(name, type);
        this.valueList = value;
        this.indexList.addAll(value);
    }

    public ArrayList<T> getValue() {
        return this.valueList;
    }

    @Override
    public boolean canRemoveSubtree(ASTNode node) {
        return this.valueList.contains(node);
    }

    @Override
    public void removeSubtree(ASTNode node) {
        this.valueList.remove(node);
    }

    @Override
    void setParent(ASTNode parent) {
        super.setParent(parent);
        for (ASTNode value : this.valueList) {
            value.setParent(parent, this);
        }
    }

    @Override
    String getId(ASTNode node) {
        return String.valueOf(super.getId(node)) + this.indexList.indexOf(node);
    }

    @Override
    Property deepCopy() {
        ArrayList<ASTNode> clonedList = new ArrayList<ASTNode>(this.valueList.size());
        for (ASTNode entry : this.valueList) {
            clonedList.add(entry.deepCopy());
        }
        return new PropertyZeroOrMore(new String(this.name), clonedList);
    }

    @Override
    public ASTNode[] getChildren() {
        return this.valueList.toArray(new ASTNode[this.valueList.size()]);
    }
}

