/*
 * Decompiled with CFR 0.152.
 */
package cide.gast;

import cide.gast.ASTNode;
import cide.gast.Property;
import cide.gast.PropertyOne;

public class PropertyWrapper<T extends ASTNode, TWrappee extends ASTNode>
extends Property {
    protected T value;
    private String wrappeeProperty;
    private boolean isRemoved = false;

    public PropertyWrapper(String name, T value, String wrappeeProperty) {
        super(name, Property.PropertyType.ONE);
        this.value = value;
        this.wrappeeProperty = wrappeeProperty;
        this.isRemoved = false;
    }

    public ASTNode getValue() {
        if (!this.isRemoved) {
            return this.value;
        }
        return this.getWrappee();
    }

    public TWrappee getWrappee() {
        return (TWrappee)((PropertyOne)((ASTNode)this.value).getProperty(this.wrappeeProperty)).getValue();
    }

    public void setValue(T value) {
        if (value != null) {
            this.value = value;
            this.isRemoved = false;
        }
    }

    @Override
    public boolean canRemoveSubtree(ASTNode node) {
        return !this.isRemoved;
    }

    @Override
    public void removeSubtree(ASTNode node) {
        if (node == this.value) {
            this.isRemoved = true;
        }
    }

    @Override
    void setParent(ASTNode parent) {
        super.setParent(parent);
        ((ASTNode)this.value).setParent(parent, this);
    }

    @Override
    Property deepCopy() {
        return new PropertyWrapper<ASTNode, TWrappee>(new String(this.name), ((ASTNode)this.value).deepCopy(), new String(this.wrappeeProperty));
    }

    @Override
    public ASTNode[] getChildren() {
        return new ASTNode[]{this.getValue()};
    }

    @Override
    public boolean isWrapper() {
        return true;
    }
}

