/*
 * Decompiled with CFR 0.152.
 */
package cide.gast;

import cide.gast.ASTNode;
import cide.gast.ASTStringNode;
import cide.gast.IToken;
import cide.gast.Property;

public class PropertyOptionalWithDefault<T extends ASTNode>
extends Property {
    protected T value;
    private final String defaultValue;
    private final ASTStringNode defaultNode;

    public PropertyOptionalWithDefault(String name, T value, String defaultValue) {
        super(name, Property.PropertyType.ONE);
        this.value = value;
        this.defaultValue = defaultValue;
        this.defaultNode = new ASTStringNode(defaultValue, this.genToken());
    }

    private IToken genToken() {
        return new IToken(){

            @Override
            public int getLength() {
                return 0;
            }

            @Override
            public int getOffset() {
                return -1;
            }
        };
    }

    public ASTNode getValue() {
        if (this.value == null) {
            return this.defaultNode;
        }
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public boolean canRemoveSubtree(ASTNode node) {
        return node == this.value;
    }

    @Override
    public void removeSubtree(ASTNode node) {
        if (node == this.value) {
            this.value = null;
        }
    }

    @Override
    void setParent(ASTNode parent) {
        super.setParent(parent);
        ((ASTNode)this.value).setParent(parent, this);
    }

    @Override
    Property deepCopy() {
        return new PropertyOptionalWithDefault<ASTNode>(new String(this.name), ((ASTNode)this.value).deepCopy(), new String(this.defaultValue));
    }

    @Override
    public ASTNode[] getChildren() {
        if (this.value != null) {
            return new ASTNode[]{this.value};
        }
        return new ASTNode[]{this.defaultNode};
    }
}

