/*
 * Decompiled with CFR 0.152.
 */
package cide.gast;

import cide.gast.ASTNode;
import cide.gast.Property;
import cide.gast.PropertyZeroOrMore;
import java.util.ArrayList;

public class PropertyList<T extends ASTNode>
extends PropertyZeroOrMore<T> {
    public PropertyList(String name, ArrayList<T> value) {
        super(name, value, Property.PropertyType.LIST);
    }

    @Override
    public void removeSubtree(ASTNode value) {
        super.removeSubtree(value);
        if (this.valueList.isEmpty()) {
            this.removeParent();
        }
        this.valueList.remove(value);
    }

    protected void removeParent() {
        assert (this.parent != null);
        Property parentsLocation = this.parent.getLocationInParent();
        assert (parentsLocation != null);
        assert (parentsLocation.canRemoveSubtree(this.parent)) : "Parent must be optional in his parent when using the &LI annotation";
        parentsLocation.removeSubtree(this.parent);
    }

    @Override
    void setParent(ASTNode parent) {
        super.setParent(parent);
    }

    @Override
    Property deepCopy() {
        ArrayList<ASTNode> clonedList = new ArrayList<ASTNode>(this.valueList.size());
        for (ASTNode entry : this.valueList) {
            clonedList.add(entry.deepCopy());
        }
        return new PropertyList(new String(this.name), clonedList);
    }
}

