/*
 * Decompiled with CFR 0.152.
 */
package cide.gast;

import cide.gast.ASTVisitor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class AbstractPrintVisitor
extends ASTVisitor {
    private final StringBuffer buffer = new StringBuffer();
    private final PrintStream outputStream;
    private List<String> tokensInCurrentLine = new ArrayList<String>();
    private int indentInCurrentLine = 0;
    public boolean generateSpaces = true;
    private int indent = 0;
    private List<String> noSpaceAfterToken;
    private List<String> noSpaceBeforeToken;

    public AbstractPrintVisitor(PrintStream out) {
        this.outputStream = out;
    }

    public AbstractPrintVisitor() {
        this.outputStream = null;
    }

    protected void printToken(String token) {
        if (this.tokensInCurrentLine.size() == 0) {
            this.indentInCurrentLine = this.indent;
        }
        this.tokensInCurrentLine.add(token);
    }

    protected void hintIncIndent() {
        ++this.indent;
    }

    protected void hintDecIndent() {
        --this.indent;
    }

    protected void hintNewLine() {
        this.closeLine();
    }

    protected void hintSingleSpace() {
        this.printToken(" ");
    }

    private void closeLine() {
        int i = 0;
        while (i < this.indentInCurrentLine) {
            this.print('\t');
            ++i;
        }
        String lastToken = null;
        for (String token : this.tokensInCurrentLine) {
            if (this.generateSpaces && lastToken != null && !this.getNoSpaceAfterToken().contains(lastToken) && !this.getNoSpaceBeforeToken().contains(token)) {
                this.print(' ');
            }
            this.print(token);
            lastToken = token;
        }
        this.print('\n');
        this.tokensInCurrentLine.clear();
        this.indentInCurrentLine = 0;
    }

    private void print(String s) {
        this.buffer.append(s);
        if (this.outputStream != null) {
            this.outputStream.print(s);
        }
    }

    private void print(char s) {
        this.buffer.append(s);
        if (this.outputStream != null) {
            this.outputStream.print(s);
        }
    }

    public String getResult() {
        if (this.tokensInCurrentLine.size() > 0) {
            this.closeLine();
        }
        return this.buffer.toString();
    }

    protected List<String> getNoSpaceAfterToken() {
        if (this.noSpaceAfterToken == null) {
            this.noSpaceAfterToken = new ArrayList<String>();
            this.noSpaceAfterToken.add("{");
            this.noSpaceAfterToken.add("(");
            this.noSpaceAfterToken.add("[");
            this.noSpaceAfterToken.add("@");
            this.noSpaceAfterToken.add(".");
        }
        return this.noSpaceAfterToken;
    }

    protected List<String> getNoSpaceBeforeToken() {
        if (this.noSpaceBeforeToken == null) {
            this.noSpaceBeforeToken = new ArrayList<String>();
            this.noSpaceBeforeToken.add("}");
            this.noSpaceBeforeToken.add(")");
            this.noSpaceBeforeToken.add("]");
            this.noSpaceBeforeToken.add(";");
            this.noSpaceBeforeToken.add(".");
        }
        return this.noSpaceBeforeToken;
    }
}

