/*
 * Decompiled with CFR 0.152.
 */
package cide.gast;

import cide.gast.IASTNode;
import cide.gast.IASTVisitor;
import cide.gast.ISourceFile;
import cide.gast.IToken;
import cide.gast.Property;
import cide.greferences.IReferenceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class ASTNode
implements IASTNode {
    protected final List<Property> properties;
    public IToken firstToken;
    public IToken lastToken;
    private ASTNode parentNode;
    private Property parentProperty;
    private String idCache = null;

    protected ASTNode(List<Property> properties, IToken firstToken, IToken lastToken) {
        this.properties = properties;
        this.firstToken = firstToken;
        this.lastToken = lastToken;
        for (Property p : properties) {
            p.setParent(this);
        }
    }

    protected ASTNode(Property[] properties, IToken ft, IToken lt) {
        this(Arrays.asList(properties), ft, lt);
    }

    @Override
    public void accept(IASTVisitor visitor) {
        if (visitor.visit(this)) {
            ArrayList<ASTNode> children = new ArrayList<ASTNode>();
            for (Property property : this.properties) {
                ASTNode[] aSTNodeArray = property.getChildren();
                int n = aSTNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ASTNode child = aSTNodeArray[n2];
                    children.add(child);
                    ++n2;
                }
            }
            Collections.sort(children, new StartPositionSorter());
            for (ASTNode child : children) {
                child.accept(visitor);
            }
        }
        visitor.postVisit(this);
    }

    @Override
    public Property getProperty(String name) {
        for (Property property : this.properties) {
            if (!property.name.equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public ISourceFile getRoot() {
        ASTNode parent = this;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return (ISourceFile)((Object)parent);
    }

    void setParent(ASTNode parentNode, Property parentProperty) {
        this.parentNode = parentNode;
        this.parentProperty = parentProperty;
    }

    @Override
    public ASTNode getParent() {
        return this.parentNode;
    }

    public Property getLocationInParent() {
        return this.parentProperty;
    }

    @Override
    public String getId() {
        if (this.idCache != null) {
            return this.idCache;
        }
        String id = "";
        if (this.parentNode != null) {
            id = String.valueOf(this.parentNode.getId()) + "/" + this.parentProperty.getId(this);
        }
        this.idCache = id;
        return id;
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    @Override
    public int getStartPosition() {
        return this.firstToken.getOffset();
    }

    @Override
    public int getLength() {
        if (this.lastToken.getOffset() == this.firstToken.getOffset()) {
            return this.firstToken.getLength();
        }
        return this.lastToken.getOffset() + this.lastToken.getLength() - this.getStartPosition();
    }

    public boolean isOptional() {
        if (this.parentProperty == null) {
            return false;
        }
        return this.parentProperty.canRemoveSubtree(this);
    }

    protected Property[] cloneProperties() {
        Property[] result = new Property[this.properties.size()];
        int i = 0;
        for (Property p : this.properties) {
            result[i++] = p.deepCopy();
        }
        return result;
    }

    @Override
    public abstract ASTNode deepCopy();

    public void remove() {
        if (!this.isOptional()) {
            return;
        }
        this.parentProperty.removeSubtree(this);
    }

    public boolean hasReferenceTypes() {
        return this.getReferenceTypes().length > 0;
    }

    public IReferenceType[] getReferenceTypes() {
        return new IReferenceType[0];
    }

    public class StartPositionSorter
    implements Comparator<ASTNode> {
        @Override
        public int compare(ASTNode o1, ASTNode o2) {
            if (o1.getStartPosition() < o2.getStartPosition()) {
                return -1;
            }
            if (o1.getStartPosition() > o2.getStartPosition()) {
                return 1;
            }
            return 0;
        }
    }
}

