/*
 * Decompiled with CFR 0.152.
 */
package cide.astgen.nparser.visitor;

import cide.astgen.nparser.ast.NAbstractValue;
import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NNonTerminal;
import cide.astgen.nparser.ast.NProduction;
import cide.astgen.nparser.ast.NTextOnly;
import cide.astgen.nparser.ast.NValue;
import cide.astgen.nparser.visitor.NVisitor;
import java.io.PrintStream;

public class SlimPrintVisitor
extends NVisitor {
    private PrintStream out;

    public SlimPrintVisitor(PrintStream out) {
        this.out = out;
    }

    @Override
    public boolean visit(NProduction p) {
        this.out.print(String.valueOf(p.getName()) + " : ");
        return super.visit(p);
    }

    @Override
    public boolean visit(NChoice c) {
        this.out.print("\n    ");
        return super.visit(c);
    }

    @Override
    public boolean visit(NNonTerminal t) {
        this.visitA(t);
        return super.visit(t);
    }

    @Override
    public boolean visit(NValue t) {
        this.visitA(t);
        return super.visit(t);
    }

    @Override
    public boolean visit(NTextOnly t) {
        this.visitA(t);
        return super.visit(t);
    }

    public boolean visitA(NAbstractValue t) {
        for (String x : t.outerPreTokens) {
            this.out.print(String.valueOf(x) + " ");
        }
        switch (t.type) {
            case ZEROORONE: {
                this.out.print("[");
                this.printInner(t);
                this.out.print("]");
                break;
            }
            case ZEROORMORE: {
                this.out.print("(");
                this.printInner(t);
                this.out.print(")*");
                break;
            }
            case ONEORMORE: {
                this.out.print("(");
                this.printInner(t);
                this.out.print(")+");
                break;
            }
            case ONE: {
                this.printInner(t);
            }
        }
        this.out.print(" ");
        for (String x : t.outerPostTokens) {
            this.out.print(String.valueOf(x) + " ");
        }
        return true;
    }

    private void printInner(NAbstractValue t) {
        for (String x : t.innerPreTokens) {
            this.out.print(String.valueOf(x) + " ");
        }
        if (t instanceof NTextOnly) {
            this.out.print("<NONE>");
        } else {
            this.out.print(t.getName());
        }
        for (String x : t.innerPostTokens) {
            this.out.print(" " + x);
        }
    }

    @Override
    public void postVisit(NChoice g) {
        if (g.getParent().getChoices().indexOf(g) != g.getParent().getChoices().size() - 1) {
            this.out.print(" |");
        }
        super.postVisit(g);
    }

    @Override
    public void postVisit(NProduction g) {
        this.out.println(";");
        this.out.println();
        super.postVisit(g);
    }
}

