/*
 * Decompiled with CFR 0.152.
 */
package cide.astgen.nparser.visitor;

import cide.astgen.nparser.ast.NAbstractValue;
import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.ast.NNonTerminal;
import cide.astgen.nparser.ast.NProduction;
import cide.astgen.nparser.ast.NTextOnly;
import cide.astgen.nparser.ast.NValue;
import cide.astgen.nparser.visitor.NVisitor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class JavaCCPrintVisitor
extends NVisitor {
    private PrintStream out;

    public JavaCCPrintVisitor(PrintStream out) {
        this.out = out;
    }

    @Override
    public boolean visit(NProduction p) {
        this.out.println(String.valueOf(p.getName()) + " " + p.getName() + "() : { ");
        this.printParameter(p);
        this.out.println("\tToken firstToken=token;");
        this.out.print("} { (");
        return super.visit(p);
    }

    private void printParameter(NProduction p) {
        p.accept(new NVisitor(){
            Set<String> knownVariables = new HashSet<String>();
            private boolean hasToken = false;
            private boolean printedList = false;

            @Override
            public boolean visit(NNonTerminal t) {
                return this.visitA(t);
            }

            @Override
            public boolean visit(NTextOnly t) {
                if (t.type != NAbstractValue.Type.ONE) {
                    return this.visitA(t);
                }
                return true;
            }

            public boolean visitA(NAbstractValue t) {
                String name = t.genVariableName();
                if (this.knownVariables.contains(name)) {
                    return true;
                }
                this.knownVariables.add(name);
                String init = "";
                if (t.type == NAbstractValue.Type.ZEROORONE) {
                    init = " = null";
                }
                if (t.type == NAbstractValue.Type.ONEORMORE || t.type == NAbstractValue.Type.ZEROORMORE) {
                    init = " = new " + t.genVariableType() + "()";
                }
                if (t.type == NAbstractValue.Type.ONEORMORE || t.type == NAbstractValue.Type.ZEROORMORE) {
                    JavaCCPrintVisitor.this.out.println("\t" + t.genVariablePlainType() + " " + t.genVariablePlainName() + ";");
                }
                JavaCCPrintVisitor.this.out.println("\t" + t.genVariableType() + " " + name + init + ";");
                if (t.isListElement() && !this.printedList) {
                    this.printedList = true;
                    JavaCCPrintVisitor.this.out.println("\tArrayList<" + t.genVariablePlainType() + "> list" + t.getParent().getChoiceIdx() + "=new ArrayList<" + t.genVariablePlainType() + ">();");
                }
                return true;
            }

            @Override
            public boolean visit(NValue t) {
                if (!this.hasToken) {
                    this.hasToken = true;
                    JavaCCPrintVisitor.this.out.println("\tToken t;");
                }
                return this.visitA(t);
            }

            @Override
            public boolean visit(NChoice c) {
                this.printedList = false;
                return super.visit(c);
            }
        });
    }

    @Override
    public void postVisit(NProduction g) {
        this.out.println();
        this.out.println(" ) }");
        this.out.println();
        super.postVisit(g);
    }

    @Override
    public boolean visit(NChoice c) {
        this.out.print("\n\t");
        return super.visit(c);
    }

    @Override
    public void postVisit(NChoice g) {
        this.out.print("\n\t{return new " + g.genClassname() + "(");
        this.printConstructorParameter(g);
        this.out.print("firstToken.next,token);}");
        if (g.getParent().getChoices().indexOf(g) != g.getParent().getChoices().size() - 1) {
            this.out.print(" |");
        }
        super.postVisit(g);
    }

    private void printConstructorParameter(NChoice g) {
        if (g.isList()) {
            this.out.print("list" + g.getChoiceIdx() + ", ");
        }
        g.accept(new NVisitor(){

            @Override
            public boolean visit(NNonTerminal t) {
                return this.visitA(t);
            }

            @Override
            public boolean visit(NValue t) {
                return this.visitA(t);
            }

            @Override
            public boolean visit(NTextOnly t) {
                if (t.type != NAbstractValue.Type.ONE) {
                    return this.visitA(t);
                }
                return true;
            }

            public boolean visitA(NAbstractValue t) {
                if (t.isListElement()) {
                    return false;
                }
                JavaCCPrintVisitor.this.out.print(t.genVariableName());
                JavaCCPrintVisitor.this.out.print(", ");
                return true;
            }
        });
    }

    @Override
    public boolean visit(NNonTerminal t) {
        this.visitA(t);
        return super.visit(t);
    }

    @Override
    public boolean visit(NTextOnly t) {
        this.visitA(t);
        return super.visit(t);
    }

    @Override
    public boolean visit(NGrammar t) {
        this.out.println(t.getIntroduction());
        return true;
    }

    @Override
    public boolean visit(NValue t) {
        this.visitA(t);
        return super.visit(t);
    }

    public boolean visitA(NAbstractValue t) {
        for (String x : t.outerPreTokens) {
            this.printToken(x, true);
        }
        switch (t.type) {
            case ZEROORONE: {
                this.out.print("[");
                this.printInner(t);
                this.out.print("]");
                break;
            }
            case ZEROORMORE: {
                this.out.print("(");
                this.printInner(t);
                this.out.print(")*");
                break;
            }
            case ONEORMORE: {
                this.out.print("(");
                this.printInner(t);
                this.out.print(")+");
                break;
            }
            case ONE: 
            case OPTIONALWITHDEFAULT: {
                this.printInner(t);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.out.print(" ");
        for (String x : t.outerPostTokens) {
            this.printToken(x, true);
        }
        return true;
    }

    private void printToken(String x, boolean spaceAfter) {
        if (x.charAt(0) == '\"') {
            if (x.substring(0, 3).equals("\"!<")) {
                this.out.print(String.valueOf(spaceAfter ? "" : " ") + x.substring(2, x.indexOf(62) + 1) + (spaceAfter ? " " : ""));
            } else {
                this.out.print(String.valueOf(spaceAfter ? "" : " ") + x + (spaceAfter ? " " : ""));
            }
        }
        if (x.charAt(0) == 'L') {
            this.out.print("LOOKAHEAD(" + this.removeQuotes(x.substring(1)) + ") ");
        }
        if (x.charAt(0) == 'J') {
            this.out.print(" {" + this.removeQuotes(x.substring(1)) + "} ");
        }
    }

    private String removeQuotes(String name) {
        if (name.length() >= 2 && name.charAt(0) == '\"') {
            return name.substring(1, name.length() - 1).replace("\\", "");
        }
        return name;
    }

    private void printInner(NAbstractValue t) {
        for (String x : t.innerPreTokens) {
            this.printToken(x, true);
        }
        if (t instanceof NNonTerminal) {
            this.out.print(String.valueOf(t.genVariablePlainName()) + "=" + t.getName() + "()");
        }
        if (t instanceof NValue) {
            this.out.print("t=" + t.getName());
            this.out.print("{" + t.genVariablePlainName() + "=new ASTStringNode(t.toString(),new WToken(t));}");
        }
        if (t instanceof NTextOnly && t.type != NAbstractValue.Type.ONE) {
            this.out.print("{" + t.genVariablePlainName() + "=new ASTTextNode(" + this.getTextTokenParameter(t) + ",new WToken(token));}");
        }
        if (t.isListElement()) {
            this.out.print("{list" + t.getParent().getChoiceIdx() + ".add(" + t.genVariablePlainName() + ");}");
        } else if (t.type == NAbstractValue.Type.ONEORMORE || t.type == NAbstractValue.Type.ZEROORMORE) {
            this.out.print("{" + t.genVariableName() + ".add(" + t.genVariablePlainName() + ");}");
        }
        for (String x : t.innerPostTokens) {
            this.printToken(x, false);
        }
    }

    private String getTextTokenParameter(NAbstractValue t) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (String s : t.innerPreTokens) {
            if (s.charAt(0) != '\"') continue;
            tokens.add(s);
        }
        for (String s : t.innerPostTokens) {
            if (s.charAt(0) != '\"') continue;
            tokens.add(s);
        }
        if (tokens.size() == 0) {
            return "";
        }
        if (tokens.size() == 1) {
            return (String)tokens.get(0);
        }
        boolean first = true;
        String result = "new String[]{";
        for (String s : tokens) {
            if (first) {
                first = false;
            } else {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + s;
        }
        result = String.valueOf(result) + "}";
        return result;
    }
}

