/*
 * Decompiled with CFR 0.152.
 */
package cide.astgen.nparser.visitor;

import cide.astgen.nparser.ast.NAbstractValue;
import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.ast.NTextOnly;
import cide.astgen.nparser.visitor.NCreateFileVisitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class CreateSimplePrintVisitorVisitor
extends NCreateFileVisitor {
    public CreateSimplePrintVisitorVisitor(File targetDir, String targetPackage) throws FileNotFoundException {
        super(targetDir, "SimplePrintVisitor.java", targetPackage);
    }

    public CreateSimplePrintVisitorVisitor(PrintStream stream, String targetPackage) {
        super(stream, targetPackage);
    }

    @Override
    public boolean visit(NGrammar g) {
        this.printHead();
        return super.visit(g);
    }

    @Override
    public void postVisit(NGrammar g) {
        this.printTail();
        super.postVisit(g);
    }

    @Override
    public boolean visit(NChoice c) {
        if (c.units.isEmpty()) {
            return false;
        }
        this.println("if (node instanceof " + c.genClassname() + ") {", 2);
        this.println(String.valueOf(c.genClassname()) + " n = (" + c.genClassname() + ")node;", 3);
        if (c.isList()) {
            this.println("Iterator<" + c.getListType() + "> listElements = n." + c.getListAccessMethod() + "().iterator();", 3);
        }
        for (NAbstractValue unit : c.units) {
            for (String t : unit.outerPreTokens) {
                this.printToken(t, 3);
            }
            this.visitUnit(unit);
            for (String t : unit.outerPostTokens) {
                this.printToken(t, 3);
            }
        }
        this.println("return false;", 3);
        this.println("}", 2);
        return false;
    }

    private void printToken(String token, int indent) {
        if (token.length() > 3 && token.subSequence(0, 3).equals("\"!<")) {
            token = String.valueOf('\"') + token.substring(token.indexOf(62) + 1);
        }
        if (token.charAt(0) == '\"') {
            this.println("printToken(\"" + token.substring(1, token.length() - 1) + "\");", indent);
        }
        if (token.charAt(0) == '@') {
            this.handleLayoutHint(token, indent);
        }
    }

    private void handleLayoutHint(String hint, int indent) {
        if (hint.indexOf(40) > 0) {
            return;
        }
        if (hint.indexOf(43) > 0) {
            this.println("hintIncIndent();", indent);
        }
        if (hint.indexOf(45) > 0) {
            this.println("hintDecIndent();", indent);
        }
        if (hint.indexOf(110) > 0) {
            this.println("hintNewLine();", indent);
        }
        if (hint.indexOf(115) > 0) {
            this.println("hintSingleSpace();", indent);
        }
    }

    void visitUnit(NAbstractValue unit) {
        if (unit instanceof NTextOnly && unit.type == NAbstractValue.Type.ONE) {
            assert (unit.innerPostTokens.isEmpty() && unit.innerPreTokens.isEmpty());
            return;
        }
        if (unit.isListElement()) {
            String command = !NAbstractValue.isMultiType(unit.type) ? "if" : "while";
            this.println(String.valueOf(command) + " (listElements.hasNext()) {", 3);
            for (String t : unit.innerPreTokens) {
                this.printToken(t, 4);
            }
            this.println("listElements.next().accept(this);", 4);
            for (String t : unit.innerPostTokens) {
                this.printToken(t, 4);
            }
            this.println("}", 3);
        } else if (!NAbstractValue.isMultiType(unit.type)) {
            this.println("{", 3);
            this.println(String.valueOf(unit.genVariablePlainType()) + " v=n." + unit.genAccessMethod() + "();", 4);
            this.println("if (v!=null) {", 4);
            for (String t : unit.innerPreTokens) {
                this.printToken(t, 5);
            }
            this.println("v.accept(this);", 5);
            for (String t : unit.innerPostTokens) {
                this.printToken(t, 5);
            }
            this.println("}", 4);
            this.println("}", 3);
        } else {
            this.println("for (" + unit.genVariablePlainType() + " v : n." + unit.genAccessMethod() + "()) {", 3);
            for (String t : unit.innerPreTokens) {
                this.printToken(t, 4);
            }
            this.println("v.accept(this);", 4);
            for (String t : unit.innerPostTokens) {
                this.printToken(t, 4);
            }
            this.println("}", 3);
        }
    }

    private void printHead() {
        this.println("package " + this.targetPackage + ";\n", 0);
        this.println("import java.util.*;", 0);
        this.println("import cide.gast.*;\n", 0);
        this.println("import java.io.PrintStream;\n", 0);
        this.println("import cide.languages.*;\n", 0);
        this.println("public class SimplePrintVisitor extends AbstractPrintVisitor implements ILanguagePrintVisitor {", 0);
        this.println("public SimplePrintVisitor(PrintStream out) {", 1);
        this.println("super(out);", 2);
        this.println("}", 1);
        this.println("public SimplePrintVisitor() {", 1);
        this.println("super();", 2);
        this.println("}", 1);
        this.println("public boolean visit(ASTNode node) {", 1);
        this.println("if (node instanceof ASTStringNode){", 2);
        this.println("printToken(((ASTStringNode)node).getValue());", 3);
        this.println("return false;", 3);
        this.println("}", 2);
        this.println("if (node instanceof ASTTextNode){", 2);
        this.println("return false;", 3);
        this.println("}", 2);
    }

    private void printTail() {
        this.println("return true;", 2);
        this.println("}", 1);
        this.println("}", 0);
    }
}

