/*
 * Decompiled with CFR 0.152.
 */
package cide.astgen.nparser.visitor;

import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.visitor.NCreateFileVisitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CreateReferenceManagerVisitor
extends NCreateFileVisitor {
    final Map<String, Set<String>> referenceSources = new HashMap<String, Set<String>>();
    final Map<String, Set<String>> referenceTargets = new HashMap<String, Set<String>>();

    public CreateReferenceManagerVisitor(File targetDir, String targetPackage) throws FileNotFoundException {
        super(targetDir, "ReferenceManager.java", targetPackage);
    }

    public CreateReferenceManagerVisitor(PrintStream stream, String targetPackage) {
        super(stream, targetPackage);
    }

    @Override
    public boolean visit(NGrammar g) {
        this.printHead();
        return super.visit(g);
    }

    @Override
    public void postVisit(NGrammar g) {
        assert (this.isConsistent());
        this.printContent();
        this.printTail();
        super.postVisit(g);
    }

    void printContent() {
        if (!this.isConsistent()) {
            return;
        }
        String types = "";
        for (String type : this.referenceSources.keySet()) {
            this.println("public final static ReferenceType " + CreateReferenceManagerVisitor.genName(type) + " = new ReferenceType(\"" + type + "\", " + this.genClassList(this.referenceSources.get(type)) + ", " + this.genClassList(this.referenceTargets.get(type)) + ");", 1);
            if (!types.equals("")) {
                types = String.valueOf(types) + ", ";
            }
            types = String.valueOf(types) + CreateReferenceManagerVisitor.genName(type);
        }
        this.println("", 1);
        this.println("public ReferenceType[] getReferenceTypes() {", 1);
        this.println("return new ReferenceType[] { " + types + " };", 2);
        this.println("}", 1);
    }

    private String genClassList(Set<String> classNames) {
        String result = "new Class[] { ";
        boolean first = true;
        for (String className : classNames) {
            if (first) {
                first = false;
            } else {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + className + ".class";
        }
        return String.valueOf(result) + " }";
    }

    public static String genName(String type) {
        return type.toLowerCase();
    }

    private void printHead() {
        if (!this.targetPackage.equals("")) {
            this.println("package " + this.targetPackage + ";\n", 0);
        }
        this.println("import java.util.*;", 0);
        this.println("import cide.greferences.*;\n", 0);
        this.println("import cide.gast.*;\n", 0);
        this.println("public class ReferenceManager implements IReferenceManager {", 0);
    }

    @Override
    public boolean visit(NChoice c) {
        String className = c.genClassname();
        for (String ref : c.collectAnnotationValues("Reference")) {
            this.add(this.referenceSources, ref, className);
        }
        for (String ref : c.collectAnnotationValues("RefTarget")) {
            this.add(this.referenceTargets, ref, className);
        }
        return true;
    }

    private void add(Map<String, Set<String>> referenceMap, String ref, String className) {
        Set<String> classSet = referenceMap.get(ref);
        if (classSet == null) {
            classSet = new HashSet<String>();
            referenceMap.put(ref, classSet);
        }
        classSet.add(className);
    }

    private void printTail() {
        this.println("}", 0);
    }

    boolean isConsistent() {
        if (this.referenceSources.keySet().contains("")) {
            return false;
        }
        return this.referenceSources.keySet().equals(this.referenceTargets.keySet());
    }
}

