/*
 * Decompiled with CFR 0.152.
 */
package cide.astgen.nparser.visitor;

import cide.astgen.nparser.ast.NAbstractValue;
import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NNonTerminal;
import cide.astgen.nparser.ast.NProduction;
import cide.astgen.nparser.ast.NTextOnly;
import cide.astgen.nparser.visitor.CreateReferenceManagerVisitor;
import cide.astgen.nparser.visitor.NVisitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ASTCreationVisitor
extends NVisitor {
    private File targetDirectory;
    private String targetPackage;
    private PrintStream out;

    public ASTCreationVisitor(File targetDirectory, String targetPackage) {
        this.targetDirectory = targetDirectory;
        this.targetPackage = targetPackage;
        this.createGenASTNode();
    }

    private void createGenASTNode() {
        this.out = this.getOutputFile("GenASTNode");
        this.printPackage(this.out);
        this.out.println("public abstract class GenASTNode extends ASTNode {");
        this.out.println("  public GenASTNode(Property[] p, Token firstToken, Token lastToken) {\n    super(p, new WToken(firstToken), new WToken(lastToken));");
        this.out.println("  }");
        this.out.println("  public GenASTNode(Property[] p, IToken firstToken, IToken lastToken) {\n    super(p, firstToken, lastToken);");
        this.out.println("  }");
        this.out.println("  public String toString() {\n    return this.getClass().getSimpleName() + \" \" + this.getStartPosition()\n        + \"-\" + (this.getStartPosition() + this.getLength());\n  }");
        this.out.println("  public String render() {\n    SimplePrintVisitor v=new SimplePrintVisitor();\n    accept(v);\n    return v.getResult();\n  }\n}");
    }

    @Override
    public boolean visit(NProduction p) {
        if (p.getChoices().size() > 1) {
            this.createAbstractClass(p);
        }
        return super.visit(p);
    }

    @Override
    public boolean visit(NChoice c) {
        this.out = this.getOutputFile(c.genClassname());
        this.printPackage(this.out);
        this.out.print("public ");
        if (c.genSuperclass() == null) {
            this.out.print("class " + c.genClassname() + " extends GenASTNode ");
        } else {
            this.out.print("class " + c.genClassname() + " extends " + c.genSuperclass() + " ");
        }
        if (c.getParent().isFirstProduction()) {
            this.out.print("implements ISourceFile ");
        }
        this.out.println("{");
        List<NAbstractValue> units = this.applyASTGenerationAnnotation(this.getRelevantUnits(c.units));
        this.out.println("  public " + c.genClassname() + "(" + this.genParamList(units) + "Token firstToken, Token lastToken) {\n" + "    super(new Property[] {");
        int idx = 0;
        while (idx < units.size()) {
            this.out.println("      " + this.genPropertyConstr(units.get(idx)) + (idx < units.size() - 1 ? "," : ""));
            ++idx;
        }
        this.out.println("    }, firstToken, lastToken);");
        this.out.println("  }");
        this.out.println("  public " + c.genClassname() + "(Property[] properties, IToken firstToken, IToken lastToken) {");
        this.out.println("    super(properties,firstToken,lastToken);");
        this.out.println("  }");
        this.out.println("  public ASTNode deepCopy() {");
        this.out.println("    return new " + c.genClassname() + "(cloneProperties(),firstToken,lastToken);");
        this.out.println("  }");
        this.generateAccessMethods(units);
        this.out.print(this.generateReferenceMethod(c));
        return super.visit(c);
    }

    String generateReferenceMethod(NChoice c) {
        List<String> references = c.collectAnnotationValues("Reference");
        if (references.size() == 0) {
            return "";
        }
        String returnValue = "";
        boolean first = true;
        for (String refType : references) {
            if (first) {
                first = false;
            } else {
                returnValue = String.valueOf(returnValue) + ", ";
            }
            returnValue = String.valueOf(returnValue) + "ReferenceManager." + CreateReferenceManagerVisitor.genName(refType);
        }
        return "  public IReferenceType[] getReferenceTypes() {\n    return new IReferenceType[]{ " + returnValue + " };\n  }\n";
    }

    private void generateAccessMethods(List<NAbstractValue> units) {
        for (NAbstractValue unit : units) {
            this.out.println("  public " + unit.genVariableType() + " " + unit.genAccessMethod() + "() {");
            this.out.println("    return ((" + this.getPropertyClass(unit) + ")getProperty(\"" + unit.genPropertyName() + "\")).getValue();");
            this.out.println("  }");
        }
    }

    private List<NAbstractValue> applyASTGenerationAnnotation(List<NAbstractValue> relevantUnits) {
        ArrayList<NAbstractValue> result = new ArrayList<NAbstractValue>(relevantUnits);
        NAbstractValue listElement = null;
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            NAbstractValue abstractValue = (NAbstractValue)iterator.next();
            if (!abstractValue.isListElement()) continue;
            assert (listElement == null || listElement.getName().equals(abstractValue.getName())) : "List elements must all be of the same type " + abstractValue.getName() + " vs " + listElement.getName();
            listElement = abstractValue;
            iterator.remove();
        }
        if (listElement != null) {
            listElement = listElement.cloneValue();
            listElement.type = NAbstractValue.Type.LIST;
            result.add(0, listElement);
        }
        return result;
    }

    private List<NAbstractValue> getRelevantUnits(List<NAbstractValue> units) {
        ArrayList<NAbstractValue> result = new ArrayList<NAbstractValue>();
        for (NAbstractValue unit : units) {
            if (unit instanceof NTextOnly && unit.type == NAbstractValue.Type.ONE) continue;
            result.add(unit);
        }
        return result;
    }

    private void printPackage(PrintStream out) {
        if (this.targetPackage != null && !this.targetPackage.equals("")) {
            out.println("package " + this.targetPackage + ";\n");
        }
        out.println("import cide.gast.*;");
        out.println("import cide.gparser.*;");
        out.println("import cide.greferences.*;");
        out.println("import java.util.*;\n");
    }

    private PrintStream getOutputFile(String classname) {
        try {
            return new PrintStream(new File(this.targetDirectory, String.valueOf(classname) + ".java"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String genPropertyConstr(NAbstractValue value) {
        String propertyClass = this.getPropertyClass(value);
        String defaultParameter = "";
        if (value.type == NAbstractValue.Type.OPTIONALWITHDEFAULT) {
            defaultParameter = ", " + value.defaultValue;
        }
        String wrappeeParameter = "";
        if (value.isWrapper()) {
            wrappeeParameter = ", \"" + ((NNonTerminal)value).getWrappeePropertyName() + "\"";
        }
        return "new " + propertyClass + "(\"" + value.genPropertyName() + "\", " + value.genVariablePlainName() + defaultParameter + wrappeeParameter + ")";
    }

    private String getPropertyClass(NAbstractValue value) {
        switch (value.type) {
            case ONEORMORE: {
                return "PropertyOneOrMore<" + value.genVariablePlainType() + ">";
            }
            case ZEROORMORE: {
                return "PropertyZeroOrMore<" + value.genVariablePlainType() + ">";
            }
            case ZEROORONE: {
                return "PropertyZeroOrOne<" + value.genVariablePlainType() + ">";
            }
            case OPTIONALWITHDEFAULT: {
                return "PropertyOptionalWithDefault<" + value.genVariablePlainType() + ">";
            }
            case LIST: {
                return "PropertyList<" + value.genVariablePlainType() + ">";
            }
            case ONE: {
                if (value.isWrapper()) {
                    return "PropertyWrapper<" + value.genVariablePlainType() + "," + value.getWrapsAroundType() + ">";
                }
                return "PropertyOne<" + value.genVariablePlainType() + ">";
            }
        }
        throw new UnsupportedOperationException();
    }

    private String genParamList(List<NAbstractValue> units) {
        String result = "";
        int idx = 0;
        while (idx < units.size()) {
            result = String.valueOf(result) + units.get(idx).genVariableType() + " " + units.get(idx).genVariablePlainName();
            result = String.valueOf(result) + ", ";
            ++idx;
        }
        return result;
    }

    @Override
    public void postVisit(NChoice g) {
        this.out.println("}");
        this.out.close();
        super.postVisit(g);
    }

    private String createAbstractClass(NProduction p) {
        PrintStream out = this.getOutputFile(p.getName());
        this.printPackage(out);
        out.println("public abstract class " + p.getName() + " extends GenASTNode " + (p.isFirstProduction() ? "implements ISourceFile " : "") + "{\n" + "  protected " + p.getName() + "(Property[] p, Token firstToken, Token lastToken) { super(p, firstToken, lastToken); }\n" + "  protected " + p.getName() + "(Property[] p, IToken firstToken, IToken lastToken) { super(p, firstToken, lastToken); }\n" + "}");
        out.close();
        return p.getName();
    }
}

