/*
 * Decompiled with CFR 0.152.
 */
package cide.astgen.nparser.ast;

import cide.astgen.nparser.ast.NAnnotation;
import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.visitor.NVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NProduction {
    final List<NChoice> choices = new ArrayList<NChoice>();
    private final List<NAnnotation> annotations = new ArrayList<NAnnotation>();
    private NGrammar grammar;
    public String name;

    public NProduction(NGrammar grammar, String name) {
        this.setGrammar(grammar);
        this.name = name;
    }

    public NProduction(NGrammar grammar) {
        this.setGrammar(grammar);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void accept(NVisitor visitor) {
        if (visitor.visit(this)) {
            for (NChoice p : this.choices) {
                p.accept(visitor);
            }
        }
        visitor.postVisit(this);
    }

    public String getName() {
        return this.name.toString();
    }

    public boolean isFirstProduction() {
        return this.getGrammar().productions.size() > 0 && this.getGrammar().productions.get(0) == this;
    }

    public List<NChoice> getChoices() {
        return Collections.unmodifiableList(this.choices);
    }

    public void addChoice(NChoice c) {
        this.choices.add(c);
    }

    List<NAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public void addAnnotation(NAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public void setGrammar(NGrammar grammar) {
        this.grammar = grammar;
    }

    public NGrammar getGrammar() {
        return this.grammar;
    }

    public String toString() {
        String r = String.valueOf(this.name) + " : ";
        for (NChoice k : this.choices) {
            r = String.valueOf(r) + "\n\t" + k.toString() + " |";
        }
        r = String.valueOf(r) + ";";
        return r;
    }
}

