/*
 * Decompiled with CFR 0.152.
 */
package cide.astgen.nparser.ast;

import cide.astgen.nparser.ast.NAbstractValue;
import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.ast.NGrammar;
import cide.astgen.nparser.ast.NProduction;
import cide.astgen.nparser.visitor.NVisitor;

public class NNonTerminal
extends NAbstractValue {
    private String origNTerminal;
    private String wrapsAroundType = null;

    public NNonTerminal(NChoice parent, NAbstractValue.Type type, String terminal) {
        super(parent, terminal.toString(), type);
        this.origNTerminal = terminal;
    }

    @Override
    public void accept(NVisitor visitor) {
        visitor.visit(this);
        visitor.postVisit(this);
    }

    @Override
    public String genVariablePlainType() {
        if (this.wrapsAroundType != null) {
            return "ASTNode";
        }
        return this.name;
    }

    @Override
    public boolean isWrapper() {
        return this.wrapsAroundType != null && this.type == NAbstractValue.Type.ONE;
    }

    @Override
    public String getWrapsAroundType() {
        return this.wrapsAroundType;
    }

    public void setWrapsAroundType(String type) {
        this.wrapsAroundType = type;
    }

    public String getWrappeePropertyName() {
        NGrammar grammar = this.parent.production.getGrammar();
        NProduction production = grammar.findProduction(this.origNTerminal);
        if (production == null) {
            return null;
        }
        if (production.choices.size() != 1) {
            throw new UnsupportedOperationException("Cannot wrap around production with multiple choices.");
        }
        for (NAbstractValue unit : production.choices.get(0).getUnits()) {
            if (!unit.isWrappee()) continue;
            return unit.genPropertyName();
        }
        return null;
    }

    @Override
    public NAbstractValue cloneValue() {
        return new NNonTerminal(this.parent, this.type, this.origNTerminal);
    }

    @Override
    protected void adjustFrom(NAbstractValue template) {
        super.adjustFrom(template);
        this.wrapsAroundType = ((NNonTerminal)template).wrapsAroundType;
    }
}

