/*
 * Decompiled with CFR 0.152.
 */
package cide.astgen.nparser.ast;

import cide.astgen.nparser.ast.NAbstractValue;
import cide.astgen.nparser.ast.NAnnotation;
import cide.astgen.nparser.ast.NProduction;
import cide.astgen.nparser.visitor.NVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NChoice {
    public final List<NAbstractValue> units;
    private final List<NAnnotation> annotations = new ArrayList<NAnnotation>();
    NProduction production;
    public String optName = null;

    public NChoice(NProduction production, List<NAbstractValue> units) {
        this.production = production;
        this.units = units;
    }

    public NChoice(NProduction production) {
        this(production, new ArrayList<NAbstractValue>());
    }

    public void accept(NVisitor visitor) {
        if (visitor.visit(this)) {
            for (NAbstractValue p : this.units) {
                p.accept(visitor);
            }
        }
        visitor.postVisit(this);
    }

    public String genClassname() {
        if (this.production.choices.size() <= 1) {
            return this.production.getName();
        }
        if (this.optName != null && this.optName.length() > 0) {
            return this.optName.toString();
        }
        return String.valueOf(this.production.getName()) + (this.getChoiceIdx() + 1);
    }

    public String genSuperclass() {
        if (this.production.choices.size() > 1) {
            return this.production.getName();
        }
        return null;
    }

    public NProduction getParent() {
        return this.production;
    }

    public List<NAbstractValue> getUnits() {
        return Collections.unmodifiableList(this.units);
    }

    public int getChoiceIdx() {
        return this.production.choices.indexOf(this);
    }

    public boolean isList() {
        for (NAbstractValue u : this.units) {
            if (!u.isListElement()) continue;
            return true;
        }
        return false;
    }

    public String getListType() {
        String result = null;
        for (NAbstractValue u : this.units) {
            if (!u.isListElement()) continue;
            assert (result == null || result.equals(u.genVariablePlainType()));
            result = u.genVariablePlainType();
        }
        return result;
    }

    public String getListAccessMethod() {
        for (NAbstractValue u : this.units) {
            if (!u.isListElement()) continue;
            return u.genAccessMethod();
        }
        return null;
    }

    public List<String> collectAnnotationValues(String string) {
        ArrayList<String> result = new ArrayList<String>();
        for (NAbstractValue unit : this.units) {
            result.addAll(unit.getAnnotationValues(string));
        }
        return result;
    }

    public void addAnnotation(NAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public NAnnotation findAnnotation(String annotationName) {
        for (NAnnotation a : this.annotations) {
            if (!a.getName().equals(annotationName)) continue;
            return a;
        }
        for (NAnnotation a : this.production.getAnnotations()) {
            if (!a.getName().equals(annotationName)) continue;
            return a;
        }
        return null;
    }

    public String findAnnotationValue(String annotationName, String valueKey) {
        NAnnotation annoation = this.findAnnotation(annotationName);
        if (annoation != null) {
            return annoation.values.get(valueKey);
        }
        return null;
    }

    public List<NAnnotation> getAnnotations() {
        ArrayList<NAnnotation> allAnnotations = new ArrayList<NAnnotation>(this.annotations);
        allAnnotations.addAll(this.production.getAnnotations());
        return Collections.unmodifiableList(allAnnotations);
    }

    public String toString() {
        String r = "";
        for (NAbstractValue u : this.getUnits()) {
            r = String.valueOf(r) + u.getName() + " ";
        }
        r = String.valueOf(r) + ":: " + this.genClassname();
        return r;
    }
}

