/*
 * Decompiled with CFR 0.152.
 */
package cide.astgen.nparser.ast;

import cide.astgen.nparser.ast.NChoice;
import cide.astgen.nparser.visitor.NVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class NAbstractValue {
    protected final NChoice parent;
    public Type type;
    public final List<String> outerPreTokens = new ArrayList<String>();
    public final List<String> innerPreTokens = new ArrayList<String>();
    public final List<String> outerPostTokens = new ArrayList<String>();
    public final List<String> innerPostTokens = new ArrayList<String>();
    public String defaultValue = null;
    public boolean isWrappee = false;
    protected final String name;
    static final String[] javaKeywords = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null"};

    public static boolean isMultiType(Type t) {
        return t == Type.ZEROORMORE || t == Type.LIST || t == Type.ONEORMORE;
    }

    protected NAbstractValue(NChoice parent, String name, Type type) {
        this.parent = parent;
        this.type = type;
        this.name = name;
    }

    public abstract void accept(NVisitor var1);

    public String genVariableType() {
        if (this.type == Type.ONEORMORE || this.type == Type.ZEROORMORE || this.type == Type.LIST) {
            return "ArrayList<" + this.genVariablePlainType() + ">";
        }
        return this.genVariablePlainType();
    }

    public abstract String genVariablePlainType();

    public boolean isWrapper() {
        return false;
    }

    public String getWrapsAroundType() {
        return null;
    }

    public boolean isWrappee() {
        return this.isWrappee;
    }

    public String getName() {
        return this.name;
    }

    public String genVariableName() {
        if (this.type == Type.ONEORMORE || this.type == Type.ZEROORMORE || this.type == Type.LIST) {
            return String.valueOf(this.genVariablePlainName()) + "List";
        }
        return this.genVariablePlainName();
    }

    public String genAccessMethod() {
        String name = this.genPropertyName();
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public String genVariablePlainName() {
        int suffix = 0;
        int choiceIdx = 0;
        while (choiceIdx < this.parent.getParent().getChoices().indexOf(this.parent)) {
            for (NAbstractValue unit : this.parent.getParent().getChoices().get(choiceIdx).getUnits()) {
                if (!unit.name.equals(this.name)) continue;
                ++suffix;
            }
            ++choiceIdx;
        }
        int idx = 0;
        while (idx < this.parent.getUnits().indexOf(this)) {
            NAbstractValue unit;
            unit = this.parent.getUnits().get(idx);
            if (unit.getName().equals(this.getName())) {
                ++suffix;
            }
            ++idx;
        }
        String result = String.valueOf(this.cleanJavaKeywords(this.name)) + (suffix > 0 ? Integer.valueOf(suffix) : "");
        result = String.valueOf(Character.toLowerCase(result.charAt(0))) + result.substring(1);
        return result;
    }

    public String genPropertyName() {
        return this.genVariablePlainName();
    }

    private String cleanJavaKeywords(String name) {
        String namel = name.toLowerCase();
        String[] stringArray = javaKeywords;
        int n = javaKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (namel.equals(keyword)) {
                name = String.valueOf(name) + "_KW";
            }
            ++n2;
        }
        return name;
    }

    public abstract NAbstractValue cloneValue();

    protected void adjustFrom(NAbstractValue template) {
        this.type = template.type;
        this.outerPreTokens.clear();
        this.outerPreTokens.addAll(template.outerPreTokens);
        this.innerPreTokens.clear();
        this.innerPreTokens.addAll(template.innerPreTokens);
        this.outerPostTokens.clear();
        this.outerPostTokens.addAll(template.outerPostTokens);
        this.innerPostTokens.clear();
        this.innerPostTokens.addAll(template.innerPostTokens);
        this.defaultValue = template.defaultValue;
        this.isWrappee = template.isWrappee;
    }

    public NChoice getParent() {
        return this.parent;
    }

    public boolean isListElement() {
        return this.innerPreTokens.contains("&LI");
    }

    public List<String> getAnnotations() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.innerPreTokens);
        result.addAll(this.innerPostTokens);
        result.addAll(this.outerPreTokens);
        result.addAll(this.outerPostTokens);
        Iterator annotationIterator = result.iterator();
        while (annotationIterator.hasNext()) {
            String annotation = (String)annotationIterator.next();
            if (annotation.charAt(0) != '@') {
                annotationIterator.remove();
                continue;
            }
            if (annotation.indexOf(40) >= 0) continue;
            annotationIterator.remove();
        }
        return result;
    }

    public List<String> getAnnotations(String annoationType) {
        List<String> result = this.getAnnotations();
        Iterator<String> annotationIterator = result.iterator();
        while (annotationIterator.hasNext()) {
            String fullAnnoation = annotationIterator.next();
            String type = fullAnnoation.substring(1, fullAnnoation.indexOf(40));
            if (type.equals(annoationType)) continue;
            annotationIterator.remove();
        }
        return result;
    }

    public List<String> getAnnotationValues(String annoationType) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> annotations = this.getAnnotations(annoationType);
        for (String annotation : annotations) {
            result.add(annotation.substring(annotation.indexOf(40) + 1, annotation.indexOf(41)));
        }
        return result;
    }

    public String toString() {
        return "[" + this.name + "]";
    }

    public static enum Type {
        ONE,
        ZEROORONE,
        ZEROORMORE,
        ONEORMORE,
        OPTIONALWITHDEFAULT,
        LIST;

    }
}

