/*
 * Decompiled with CFR 0.152.
 */
package builder.xmi;

import de.ovgu.cide.fstgen.ast.FSTNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMINode
extends FSTNonTerminal {
    private Node node;
    private Element root;
    private Map<String, String> nodeAttributes = new HashMap<String, String>();
    private boolean ignoreID;
    private boolean copyMode;

    public XMINode(Node node, Element root, boolean ignoreID, boolean copyMode) {
        super(node.getNodeName(), "");
        this.root = root;
        this.node = node;
        this.ignoreID = ignoreID;
        this.copyMode = copyMode;
        String name = "";
        String type = "";
        String id = "";
        String ref = "";
        type = node.getNodeName();
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int i = 0;
            while (i < map.getLength()) {
                Node subNode = map.item(i);
                String nodeName = subNode.getNodeName();
                String nodeValue = subNode.getNodeValue();
                if (nodeName.equals("xmi.id")) {
                    id = nodeValue;
                } else if (nodeName.equals("xmi.idref")) {
                    ref = nodeValue;
                } else if (nodeName.equals("name")) {
                    name = nodeValue;
                } else {
                    this.setNodeAttribute(nodeName, nodeValue);
                }
                ++i;
            }
            if (copyMode) {
                if (!id.isEmpty()) {
                    this.setNodeAttribute("xmi.id", id);
                    this.setName(id);
                }
                if (!name.isEmpty()) {
                    this.setNodeAttribute("name", name);
                }
                if (!ref.isEmpty()) {
                    this.setNodeAttribute("xmi.idref", String.valueOf(type) + this.IdToElement(ref, type));
                }
            } else {
                if (name.equals("")) {
                    if (!id.equals("") && !ignoreID) {
                        this.setNodeAttribute("xmi.id", id);
                        this.setName(id);
                    }
                } else {
                    this.setName(name);
                    this.setNodeAttribute("name", name);
                    if (!(type.equals("UML:Parameter") | type.equals("UML:Attribute") | type.equals("UML:Operation") || ignoreID || id.equals(""))) {
                        this.setNodeAttribute("xmi.id", String.valueOf(type) + name);
                    }
                }
                if (!ref.equals("")) {
                    String newRef = this.IdToElement(ref, type);
                    if (newRef.equals("")) {
                        this.setNodeAttribute("xmi.idref", ref);
                    } else {
                        this.setNodeAttribute("xmi.idref", String.valueOf(type) + newRef);
                    }
                }
            }
            if (type.equals("UML:Multiplicity") || type.equals("UML:MultiplicityRange")) {
                this.setName("id");
            }
            if (type.equals("UML:Association.connection") || type.equals("UML:ClassifierRole.multiplicity")) {
                this.ignoreID = true;
            }
            if (type.equals("UML:Collaboration.interaction")) {
                this.copyMode = true;
            }
        }
    }

    public void toFST() {
        NodeList children = this.node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("#text")) {
                XMINode xmiNode = new XMINode(child, this.getRoot(), this.ignoreID, this.copyMode);
                xmiNode.toFST();
                this.addChild(xmiNode);
            }
            ++i;
        }
    }

    public Element toXMI(Document doc) {
        Element node = doc.createElement(this.getType());
        Map<String, String> attributes = this.getAttributes();
        for (String key : attributes.keySet()) {
            node.setAttribute(key, attributes.get(key));
        }
        for (FSTNode fstnode : this.getChildren()) {
            XMINode xminode = (XMINode)fstnode;
            node.appendChild(xminode.toXMI(doc));
        }
        return node;
    }

    @Override
    public FSTNode getShallowClone() {
        return new XMINode(this.node, this.getRoot(), this.ignoreID, this.copyMode);
    }

    @Override
    public FSTNode getDeepClone() {
        XMINode clone = new XMINode(this.node.cloneNode(true), this.getRoot(), this.ignoreID, this.copyMode);
        for (FSTNode fstNode : this.getChildren()) {
            clone.addChild(fstNode.getDeepClone());
        }
        return clone;
    }

    public void setNodeAttribute(String name, String value) {
        this.nodeAttributes.put(name, value);
    }

    public Map<String, String> getAttributes() {
        return this.nodeAttributes;
    }

    public String getNodeAttribute(String name) {
        return this.nodeAttributes.get(name);
    }

    public Element getNode() {
        return (Element)this.node;
    }

    public Element getRoot() {
        return this.root;
    }

    public String IdToElement(String id, String rootType) {
        NodeList dataTypes = this.root.getElementsByTagName(rootType);
        int i = 0;
        while (i < dataTypes.getLength()) {
            Element dataType = (Element)dataTypes.item(i);
            if (dataType.getAttribute("xmi.id").equals(id)) {
                return dataType.getAttribute("name");
            }
            ++i;
        }
        System.err.println("Can't find " + id + " in " + rootType);
        return id;
    }
}

