/*
 * Decompiled with CFR 0.152.
 */
package builder.xmi;

import builder.xmi.XMINode;
import cide.gparser.ParseException;
import de.ovgu.cide.fstgen.ast.AbstractFSTParser;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMIFactory {
    private Document xmi;
    private FSTNonTerminal FSTMasterRoot;
    Element docEle;

    public XMIFactory(File filename, FSTNonTerminal fstroot) throws ParseException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.xmi = db.parse(filename);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            throw new ParseException(se.toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.FSTMasterRoot = fstroot;
        this.docEle = this.xmi.getDocumentElement();
    }

    public void extract() {
        this.extractFST(this.docEle, this.FSTMasterRoot);
    }

    private void extractFST(Element masterRoot, FSTNonTerminal FSTroot) {
        AbstractFSTParser.fstnodes.add(FSTroot);
        NodeList modelList = masterRoot.getElementsByTagName("UML:Namespace.ownedElement");
        if (modelList.getLength() > 0) {
            Element root = (Element)modelList.item(0);
            NodeList childNodes = root.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node = childNodes.item(i);
                String nodeName = node.getNodeName();
                if (!nodeName.equals("#text")) {
                    XMINode xmiab = new XMINode(node, root, false, false);
                    xmiab.toFST();
                    FSTroot.addChild(xmiab);
                }
                ++i;
            }
        }
    }
}

