/*
 * Decompiled with CFR 0.152.
 */
package builder;

import builder.ArtifactBuilderInterface;
import cide.gparser.ParseException;
import de.ovgu.cide.fstgen.ast.AbstractFSTParser;
import de.ovgu.cide.fstgen.ast.FSTFeatureNode;
import de.ovgu.cide.fstgen.ast.FSTNonTerminal;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class ArtifactBuilder
implements ArtifactBuilderInterface {
    private String baseDirectoryName;
    private LinkedList<FSTNonTerminal> featureNodes = new LinkedList();
    private String[] suffixes;
    private boolean preprocessNode = false;

    @Override
    public boolean isPreprocessNode() {
        return this.preprocessNode;
    }

    @Override
    public void setPreprocessNode(boolean preprocessNode) {
        this.preprocessNode = preprocessNode;
    }

    public ArtifactBuilder(String suffix) {
        String[] suffixes = new String[]{suffix};
        this.suffixes = suffixes;
    }

    public ArtifactBuilder(String[] suffixes) {
        this.suffixes = suffixes;
    }

    protected String getSuffix() {
        if (this.getSuffixes().length > 0) {
            return this.suffixes[0];
        }
        return "";
    }

    protected String[] getSuffixes() {
        return this.suffixes;
    }

    @Override
    public LinkedList<FSTNonTerminal> getFeatures() {
        return this.featureNodes;
    }

    public abstract void processNode(FSTNonTerminal var1, StringTokenizer var2, File var3) throws FileNotFoundException, ParseException;

    @Override
    public void setBaseDirectoryName(String baseDirectoryName) {
        this.baseDirectoryName = baseDirectoryName;
    }

    @Override
    public String getBaseDirectoryName() {
        return this.baseDirectoryName;
    }

    private FSTNonTerminal getFeatureNodeByName(String name) {
        for (FSTNonTerminal featureNode : this.featureNodes) {
            if (!featureNode.getName().equals(name)) continue;
            return featureNode;
        }
        FSTFeatureNode newFeatureNode = new FSTFeatureNode(name);
        this.featureNodes.add(newFeatureNode);
        return newFeatureNode;
    }

    @Override
    public void preprocessFile(File inputFile) throws FileNotFoundException {
    }

    @Override
    public void processFile(File inputFile) throws FileNotFoundException, ParseException {
        System.out.println("processing: " + inputFile.getPath());
        FSTNonTerminal parent = null;
        StringTokenizer st = new StringTokenizer(inputFile.getPath(), File.separator);
        int beginBaseDir = this.getBaseDirectoryName().lastIndexOf(File.separator) < 0 ? 0 : this.getBaseDirectoryName().lastIndexOf(File.separator) + 1;
        int endBaseDir = this.getBaseDirectoryName().length();
        String baseDir = this.getBaseDirectoryName().substring(beginBaseDir, endBaseDir);
        String fileDir = st.nextToken();
        while (st.hasMoreTokens()) {
            if (baseDir.equals(fileDir)) break;
            fileDir = st.nextToken();
        }
        if (baseDir.equals(fileDir)) {
            String featureName = st.nextToken();
            parent = this.getFeatureNodeByName(featureName);
            AbstractFSTParser.fstnodes.add(new FSTNonTerminal("Feature", parent.getName()));
            AbstractFSTParser.fstnodes.add(new FSTNonTerminal("EOF Marker", inputFile.toString()));
            while (st.hasMoreTokens()) {
                if (st.countTokens() > 1) {
                    FSTNonTerminal newNode = new FSTNonTerminal("Folder", st.nextToken());
                    FSTNonTerminal oldNode = (FSTNonTerminal)parent.getCompatibleChild(newNode);
                    if (parent != null && oldNode == null) {
                        parent.addChild(newNode);
                        parent = newNode;
                        continue;
                    }
                    parent = oldNode;
                    continue;
                }
                this.processNode(parent, st, inputFile);
            }
        }
    }

    @Override
    public boolean acceptFile(File inputFile) {
        if (inputFile.isFile()) {
            String[] stringArray = this.getSuffixes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                if (inputFile.getName().endsWith(suffix)) {
                    AbstractFSTParser.fstnodes.add(0, new FSTNonTerminal("language", suffix));
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

